/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.Version;
import org.hibernate.search.spi.SearchFactoryIntegrator;
import org.infinispan.Cache;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.backend.QueryInterceptor;
import org.infinispan.query.impl.CacheQueryImpl;

public class QueryFactory {
    private final Cache cache;
    private final SearchFactoryIntegrator searchFactory;
    private final QueryInterceptor queryInterceptor;
    private final Version luceneVersion;

    public QueryFactory(Cache cache) {
        this(cache, null);
    }

    public QueryFactory(Cache cache, Version luceneVersion) {
        Version version = this.luceneVersion = luceneVersion == null ? Version.LUCENE_CURRENT : luceneVersion;
        if (cache == null) {
            throw new IllegalArgumentException("cache parameter shall not be null");
        }
        this.cache = cache;
        this.searchFactory = QueryFactory.extractType(cache, SearchFactoryIntegrator.class);
        this.queryInterceptor = QueryFactory.extractType(cache, QueryInterceptor.class);
    }

    private static <T> T extractType(Cache cache, Class<T> class1) {
        ComponentRegistry componentRegistry = cache.getAdvancedCache().getComponentRegistry();
        Object component = componentRegistry.getComponent(class1);
        if (component == null) {
            throw new IllegalArgumentException("Indexing was not enabled on this cache. " + class1 + " not found in registry");
        }
        return (T)component;
    }

    public CacheQuery getQuery(Query luceneQuery, Class<?> ... classes) {
        this.queryInterceptor.enableClasses(classes);
        return new CacheQueryImpl(luceneQuery, this.searchFactory, this.cache, classes);
    }

    public CacheQuery getBasicQuery(String field, String search) throws ParseException {
        QueryParser parser = new QueryParser(this.luceneVersion, field, (Analyzer)new StandardAnalyzer(this.luceneVersion));
        Query luceneQuery = parser.parse(search);
        return new CacheQueryImpl(luceneQuery, this.searchFactory, this.cache, new Class[0]);
    }

    public CacheQuery getBasicQuery(String field, String search, Class<?> ... classes) throws ParseException {
        this.queryInterceptor.enableClasses(classes);
        QueryParser parser = new QueryParser(this.luceneVersion, field, (Analyzer)new StandardAnalyzer(this.luceneVersion));
        Query luceneQuery = parser.parse(search);
        return new CacheQueryImpl(luceneQuery, this.searchFactory, this.cache, new Class[0]);
    }
}

