/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query;

import org.apache.lucene.search.Query;
import org.hibernate.search.SearchFactory;
import org.hibernate.search.query.dsl.EntityContext;
import org.hibernate.search.spi.SearchFactoryIntegrator;
import org.infinispan.Cache;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.SearchManager;
import org.infinispan.query.backend.QueryInterceptor;
import org.infinispan.query.impl.CacheQueryImpl;

class SearchManagerImpl
implements SearchManager {
    private final Cache cache;
    private final SearchFactoryIntegrator searchFactory;
    private final QueryInterceptor queryInterceptor;

    SearchManagerImpl(Cache cache) {
        if (cache == null) {
            throw new IllegalArgumentException("cache parameter shall not be null");
        }
        this.cache = cache;
        this.searchFactory = SearchManagerImpl.extractType(cache, SearchFactoryIntegrator.class);
        this.queryInterceptor = SearchManagerImpl.extractType(cache, QueryInterceptor.class);
    }

    private static <T> T extractType(Cache cache, Class<T> class1) {
        ComponentRegistry componentRegistry = cache.getAdvancedCache().getComponentRegistry();
        Object component = componentRegistry.getComponent(class1);
        if (component == null) {
            throw new IllegalArgumentException("Indexing was not enabled on this cache. " + class1 + " not found in registry");
        }
        return (T)component;
    }

    @Override
    public CacheQuery getQuery(Query luceneQuery, Class<?> ... classes) {
        this.queryInterceptor.enableClasses(classes);
        return new CacheQueryImpl(luceneQuery, this.searchFactory, this.cache, classes);
    }

    @Override
    public EntityContext buildQueryBuilderForClass(Class<?> entityType) {
        this.queryInterceptor.enableClasses(new Class[]{entityType});
        return this.searchFactory.buildQueryBuilder().forEntity(entityType);
    }

    @Override
    public SearchFactory getSearchFactory() {
        return this.searchFactory;
    }
}

