/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.backend;

import org.infinispan.CacheException;
import org.infinispan.query.Transformable;
import org.infinispan.query.Transformer;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class KeyTransformationHandler {
    private static final Log log = LogFactory.getLog(KeyTransformationHandler.class);

    public static Object stringToKey(String s) {
        char type = s.charAt(0);
        switch (type) {
            case 'S': {
                return s.substring(2);
            }
            case 'I': {
                return Integer.parseInt(s.substring(2));
            }
            case 'Y': {
                return Byte.parseByte(s.substring(2));
            }
            case 'L': {
                return Long.parseLong(s.substring(2));
            }
            case 'X': {
                return Short.parseShort(s.substring(2));
            }
            case 'D': {
                return Double.parseDouble(s.substring(2));
            }
            case 'F': {
                return Float.valueOf(Float.parseFloat(s.substring(2)));
            }
            case 'B': {
                return Boolean.parseBoolean(s.substring(2));
            }
            case 'C': {
                return Character.valueOf(s.charAt(2));
            }
            case 'T': {
                int indexOfSecondDelimiter = s.indexOf(":", 2);
                String keyClassName = s.substring(2, indexOfSecondDelimiter);
                String keyAsString = s.substring(indexOfSecondDelimiter + 1);
                Transformer t = null;
                Class<?> keyClass = null;
                try {
                    keyClass = Thread.currentThread().getContextClassLoader().loadClass(keyClassName);
                }
                catch (ClassNotFoundException e) {
                    log.error((Object)("Could not locate class " + keyClass), (Throwable)e);
                }
                if (keyClass != null) {
                    t = KeyTransformationHandler.getTransformer(keyClass);
                }
                if (t == null) {
                    throw new CacheException("Cannot find an appropriate Transformer for key type " + keyClass);
                }
                return t.fromString(keyAsString);
            }
        }
        throw new CacheException("Unknown type metadata " + type);
    }

    public static String keyToString(Object key) {
        int prefix = 32;
        Transformer tf = null;
        if (KeyTransformationHandler.isStringOrPrimitive(key)) {
            if (key instanceof String) {
                prefix = 83;
            } else if (key instanceof Integer) {
                prefix = 73;
            } else if (key instanceof Boolean) {
                prefix = 66;
            } else if (key instanceof Long) {
                prefix = 76;
            } else if (key instanceof Float) {
                prefix = 70;
            } else if (key instanceof Double) {
                prefix = 68;
            } else if (key instanceof Short) {
                prefix = 88;
            } else if (key instanceof Byte) {
                prefix = 89;
            } else if (key instanceof Character) {
                prefix = 67;
            }
            return (char)prefix + ":" + key;
        }
        tf = KeyTransformationHandler.getTransformer(key.getClass());
        if (tf != null) {
            return "T:" + key.getClass().getName() + ":" + tf.toString(key);
        }
        throw new IllegalArgumentException("Indexing only works with entries keyed on Strings, primitives and classes that have the @Transformable annotation - you passed in a " + key.getClass().toString());
    }

    private static boolean isStringOrPrimitive(Object key) {
        return key instanceof String || key instanceof Integer || key instanceof Long || key instanceof Float || key instanceof Double || key instanceof Boolean || key instanceof Short || key instanceof Byte || key instanceof Character;
    }

    private static Transformer getTransformer(Class<?> keyClass) {
        Transformable t = keyClass.getAnnotation(Transformable.class);
        Transformer tf = null;
        if (t != null) {
            try {
                tf = t.transformer().newInstance();
            }
            catch (Exception e) {
                log.error((Object)("Cannot instantiate an instance of Transformer class " + t.transformer() + "!"), (Throwable)e);
            }
        }
        return tf;
    }
}

