/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.blackbox;

import java.util.List;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Query;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.config.FluentConfiguration;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.Search;
import org.infinispan.query.backend.QueryInterceptor;
import org.infinispan.query.helper.TestQueryHelperFactory;
import org.infinispan.query.test.Person;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class ClusteredCacheTest
extends MultipleCacheManagersTest {
    private static final Log log = LogFactory.getLog(Person.class);
    Cache<String, Person> cache1;
    Cache<String, Person> cache2;
    Person person1;
    Person person2;
    Person person3;
    Person person4;
    QueryParser queryParser;
    Query luceneQuery;
    CacheQuery cacheQuery;
    final String key1 = "Navin";
    final String key2 = "BigGoat";
    final String key3 = "MiniGoat";

    public ClusteredCacheTest() {
        this.cleanup = AbstractCacheTest.CleanupPhase.AFTER_METHOD;
    }

    protected void enhanceConfig(FluentConfiguration cacheCfg) {
    }

    protected void createCacheManagers() throws Throwable {
        FluentConfiguration cacheCfg = ClusteredCacheTest.getDefaultClusteredConfig((Configuration.CacheMode)Configuration.CacheMode.REPL_SYNC).fluent();
        cacheCfg.indexing().indexLocalOnly(Boolean.valueOf(false)).addProperty("hibernate.search.default.directory_provider", "ram");
        this.enhanceConfig(cacheCfg);
        List caches = this.createClusteredCaches(2, cacheCfg.build());
        this.cache1 = (Cache)caches.get(0);
        this.cache2 = (Cache)caches.get(1);
    }

    private void prepareTestData() {
        this.person1 = new Person();
        this.person1.setName("Navin Surtani");
        this.person1.setBlurb("Likes playing WoW");
        this.person2 = new Person();
        this.person2.setName("BigGoat");
        this.person2.setBlurb("Eats grass");
        this.person3 = new Person();
        this.person3.setName("MiniGoat");
        this.person3.setBlurb("Eats cheese");
        this.cache1.put((Object)"Navin", (Object)this.person1);
        this.cache1.put((Object)"BigGoat", (Object)this.person2);
        this.cache1.put((Object)"MiniGoat", (Object)this.person3);
    }

    public void testSimple() throws ParseException {
        this.prepareTestData();
        this.cacheQuery = TestQueryHelperFactory.createCacheQuery(this.cache2, "blurb", "playing");
        List found = this.cacheQuery.list();
        assert (found.size() == 1);
        if (found.get(0) == null) {
            log.warn((Object)"found.get(0) is null");
            Person p1 = (Person)this.cache2.get((Object)"Navin");
            if (p1 == null) {
                log.warn((Object)"Person p1 is null in sc2 and cannot actually see the data of person1 in sc1");
            } else {
                log.trace((Object)("p1 name is  " + p1.getName()));
            }
        }
        assert (found.get(0).equals(this.person1));
    }

    private void assertQueryInterceptorPresent(Cache<?, ?> c) {
        CommandInterceptor i = TestingUtil.findInterceptor(c, QueryInterceptor.class);
        assert (i != null) : "Expected to find a QueryInterceptor, only found " + c.getAdvancedCache().getInterceptorChain();
    }

    public void testModified() throws ParseException {
        this.prepareTestData();
        this.assertQueryInterceptorPresent(this.cache2);
        this.queryParser = TestQueryHelperFactory.createQueryParser("blurb");
        this.luceneQuery = this.queryParser.parse("playing");
        this.cacheQuery = Search.getSearchManager(this.cache2).getQuery(this.luceneQuery, new Class[0]);
        List found = this.cacheQuery.list();
        assert (found.size() == 1) : "Expected list of size 1, was of size " + found.size();
        assert (found.get(0).equals(this.person1));
        this.person1.setBlurb("Likes pizza");
        this.cache1.put((Object)"Navin", (Object)this.person1);
        this.queryParser = TestQueryHelperFactory.createQueryParser("blurb");
        this.luceneQuery = this.queryParser.parse("pizza");
        this.cacheQuery = Search.getSearchManager(this.cache2).getQuery(this.luceneQuery, new Class[0]);
        found = this.cacheQuery.list();
        assert (found.size() == 1);
        assert (found.get(0).equals(this.person1));
    }

    public void testAdded() throws ParseException {
        this.prepareTestData();
        this.queryParser = TestQueryHelperFactory.createQueryParser("blurb");
        this.luceneQuery = this.queryParser.parse("eats");
        this.cacheQuery = Search.getSearchManager(this.cache2).getQuery(this.luceneQuery, new Class[0]);
        List found = this.cacheQuery.list();
        assert (found.size() == 2) : "Size of list should be 2";
        assert (found.contains(this.person2));
        assert (found.contains(this.person3));
        assert (!found.contains(this.person4)) : "This should not contain object person4";
        this.person4 = new Person();
        this.person4.setName("Mighty Goat");
        this.person4.setBlurb("Also eats grass");
        this.cache1.put((Object)"mighty", (Object)this.person4);
        this.luceneQuery = this.queryParser.parse("eats");
        this.cacheQuery = Search.getSearchManager(this.cache2).getQuery(this.luceneQuery, new Class[0]);
        found = this.cacheQuery.list();
        assert (found.size() == 3) : "Size of list should be 3";
        assert (found.contains(this.person2));
        assert (found.contains(this.person3));
        assert (found.contains(this.person4)) : "This should now contain object person4";
    }

    public void testRemoved() throws ParseException {
        this.prepareTestData();
        this.queryParser = TestQueryHelperFactory.createQueryParser("blurb");
        this.luceneQuery = this.queryParser.parse("eats");
        this.cacheQuery = Search.getSearchManager(this.cache2).getQuery(this.luceneQuery, new Class[0]);
        List found = this.cacheQuery.list();
        assert (found.size() == 2);
        assert (found.contains(this.person2));
        assert (found.contains(this.person3)) : "This should still contain object person3";
        this.cache1.remove((Object)"MiniGoat");
        this.queryParser = TestQueryHelperFactory.createQueryParser("blurb");
        this.luceneQuery = this.queryParser.parse("eats");
        this.cacheQuery = Search.getSearchManager(this.cache2).getQuery(this.luceneQuery, new Class[0]);
        found = this.cacheQuery.list();
    }

    public void testGetResultSize() throws ParseException {
        this.prepareTestData();
        this.queryParser = TestQueryHelperFactory.createQueryParser("blurb");
        this.luceneQuery = this.queryParser.parse("playing");
        this.cacheQuery = Search.getSearchManager(this.cache2).getQuery(this.luceneQuery, new Class[0]);
        List found = this.cacheQuery.list();
        assert (found.size() == 1);
    }

    public void testClear() throws ParseException {
        this.prepareTestData();
        this.queryParser = TestQueryHelperFactory.createQueryParser("blurb");
        this.luceneQuery = this.queryParser.parse("eats");
        this.cacheQuery = Search.getSearchManager(this.cache1).getQuery(this.luceneQuery, new Class[0]);
        this.luceneQuery = this.queryParser.parse("playing");
        Query[] queries = new Query[]{this.luceneQuery, this.luceneQuery};
        this.luceneQuery = this.luceneQuery.combine(queries);
        this.cacheQuery = Search.getSearchManager(this.cache1).getQuery(this.luceneQuery, new Class[0]);
        assert (this.cacheQuery.getResultSize() == 3);
        this.cacheQuery = Search.getSearchManager(this.cache2).getQuery(this.luceneQuery, new Class[0]);
        assert (this.cacheQuery.getResultSize() == 3);
        this.cache1.clear();
        this.cacheQuery = Search.getSearchManager(this.cache1).getQuery(this.luceneQuery, new Class[0]);
        assert (this.cacheQuery.getResultSize() == 0);
        this.cacheQuery = Search.getSearchManager(this.cache2).getQuery(this.luceneQuery, new Class[0]);
        assert (this.cacheQuery.getResultSize() == 0);
    }
}

