/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.blackbox;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.Assert;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.PrefixFilter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.hibernate.search.engine.SearchFactoryImplementor;
import org.hibernate.search.spi.SearchFactoryIntegrator;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.config.FluentConfiguration;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.QueryIterator;
import org.infinispan.query.Search;
import org.infinispan.query.helper.TestQueryHelperFactory;
import org.infinispan.query.test.AnotherGrassEater;
import org.infinispan.query.test.Person;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.blackbox.LocalCacheTest")
public class LocalCacheTest
extends SingleCacheManagerTest {
    protected Person person1;
    protected Person person2;
    protected Person person3;
    protected Person person4;
    protected Person person5;
    protected Person person6;
    protected AnotherGrassEater anotherGrassEater;
    protected QueryParser queryParser;
    protected String key1 = "Navin";
    protected String key2 = "BigGoat";
    protected String key3 = "MiniGoat";
    protected String anotherGrassEaterKey = "anotherGrassEaterKey";

    public LocalCacheTest() {
        this.cleanup = AbstractCacheTest.CleanupPhase.AFTER_METHOD;
    }

    public void testSimple() throws ParseException {
        this.loadTestingData();
        CacheQuery cacheQuery = TestQueryHelperFactory.createCacheQuery(this.cache, "blurb", "playing");
        List found = cacheQuery.list();
        int elems = found.size();
        assert (elems == 1) : "Expected 1 but was " + elems;
        Object val = found.get(0);
        assert (val.equals(this.person1)) : "Expected " + this.person1 + " but was " + val;
    }

    public void testEagerIterator() throws ParseException {
        this.loadTestingData();
        CacheQuery cacheQuery = TestQueryHelperFactory.createCacheQuery(this.cache, "blurb", "playing");
        QueryIterator found = cacheQuery.iterator();
        assert (found.isFirst());
        assert (found.isLast());
    }

    public void testMultipleResults() throws ParseException {
        this.loadTestingData();
        this.queryParser = TestQueryHelperFactory.createQueryParser("name");
        Query luceneQuery = this.queryParser.parse("goat");
        CacheQuery cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(luceneQuery, new Class[0]);
        List found = cacheQuery.list();
        assert (found.size() == 2);
        assert (found.get(0) == this.person2);
        assert (found.get(1) == this.person3);
    }

    public void testModified() throws ParseException {
        this.loadTestingData();
        this.queryParser = TestQueryHelperFactory.createQueryParser("blurb");
        Query luceneQuery = this.queryParser.parse("playing");
        CacheQuery cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(luceneQuery, new Class[0]);
        List found = cacheQuery.list();
        assert (found.size() == 1);
        assert (found.get(0).equals(this.person1));
        this.person1.setBlurb("Likes pizza");
        this.cache.put((Object)this.key1, (Object)this.person1);
        this.queryParser = TestQueryHelperFactory.createQueryParser("blurb");
        luceneQuery = this.queryParser.parse("pizza");
        cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(luceneQuery, new Class[0]);
        found = cacheQuery.list();
        assert (found.size() == 1);
        assert (found.get(0).equals(this.person1));
    }

    public void testAdded() throws ParseException {
        this.assertIndexingKnows((Cache<Object, Object>)this.cache, new Class[0]);
        this.loadTestingData();
        this.assertIndexingKnows((Cache<Object, Object>)this.cache, Person.class, AnotherGrassEater.class);
        this.queryParser = TestQueryHelperFactory.createQueryParser("name");
        Query luceneQuery = this.queryParser.parse("Goat");
        CacheQuery cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(luceneQuery, new Class[0]);
        List found = cacheQuery.list();
        assert (found.size() == 2) : "Size of list should be 2";
        assert (found.contains(this.person2));
        assert (found.contains(this.person3));
        assert (!found.contains(this.person4)) : "This should not contain object person4";
        this.person4 = new Person();
        this.person4.setName("Mighty Goat");
        this.person4.setBlurb("Also eats grass");
        this.cache.put((Object)"mighty", (Object)this.person4);
        luceneQuery = this.queryParser.parse("Goat");
        cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(luceneQuery, new Class[0]);
        found = cacheQuery.list();
        assert (found.size() == 3) : "Size of list should be 3";
        assert (found.contains(this.person2));
        assert (found.contains(this.person3));
        assert (found.contains(this.person4)) : "This should now contain object person4";
    }

    public void testRemoved() throws ParseException {
        this.loadTestingData();
        this.queryParser = TestQueryHelperFactory.createQueryParser("name");
        Query luceneQuery = this.queryParser.parse("Goat");
        CacheQuery cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(luceneQuery, new Class[0]);
        List found = cacheQuery.list();
        assert (found.size() == 2);
        assert (found.contains(this.person2));
        assert (found.contains(this.person3)) : "This should still contain object person3";
        this.cache.remove((Object)this.key3);
        luceneQuery = this.queryParser.parse("Goat");
        cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(luceneQuery, new Class[0]);
        found = cacheQuery.list();
        assert (found.size() == 1);
        assert (found.contains(this.person2));
        assert (!found.contains(this.person3)) : "The search should not return person3";
    }

    public void testUpdated() throws ParseException {
        this.loadTestingData();
        this.queryParser = TestQueryHelperFactory.createQueryParser("name");
        Query luceneQuery = this.queryParser.parse("Goat");
        CacheQuery cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(luceneQuery, new Class[0]);
        List found = cacheQuery.list();
        assert (found.size() == 2) : "Size of list should be 2";
        assert (found.contains(this.person2)) : "The search should have person2";
        this.cache.put((Object)this.key2, (Object)this.person1);
        luceneQuery = this.queryParser.parse("Goat");
        cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(luceneQuery, new Class[0]);
        found = cacheQuery.list();
        assert (found.size() == 1) : "Size of list should be 1";
        assert (!found.contains(this.person2)) : "Person 2 should not be found now";
        assert (!found.contains(this.person1)) : "Person 1 should not be found because it does not meet the search criteria";
    }

    public void testSetSort() throws ParseException {
        this.loadTestingData();
        this.person2.setAge(35);
        this.person3.setAge(12);
        Sort sort = new Sort(new SortField("age", 3));
        this.queryParser = TestQueryHelperFactory.createQueryParser("name");
        Query luceneQuery = this.queryParser.parse("Goat");
        CacheQuery cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(luceneQuery, new Class[0]);
        List found = cacheQuery.list();
        assert (found.size() == 2);
        cacheQuery.sort(sort);
        found = cacheQuery.list();
        assert (found.size() == 2);
        assert (found.get(0).equals(this.person2));
        assert (found.get(1).equals(this.person3));
    }

    public void testSetFilter() throws ParseException {
        this.loadTestingData();
        this.queryParser = TestQueryHelperFactory.createQueryParser("name");
        Query luceneQuery = this.queryParser.parse("goat");
        CacheQuery cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(luceneQuery, new Class[0]);
        List found = cacheQuery.list();
        assert (found.size() == 2);
        PrefixFilter filter = new PrefixFilter(new Term("blurb", "cheese"));
        cacheQuery.filter((Filter)filter);
        found = cacheQuery.list();
        assert (found.size() == 1);
    }

    public void testLazyIterator() throws ParseException {
        this.loadTestingData();
        this.queryParser = TestQueryHelperFactory.createQueryParser("blurb");
        Query luceneQuery = this.queryParser.parse("playing");
        CacheQuery cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(luceneQuery, new Class[0]);
        QueryIterator found = cacheQuery.lazyIterator();
        assert (found.isFirst());
        assert (found.isLast());
    }

    public void testGetResultSize() throws ParseException {
        this.loadTestingData();
        this.queryParser = TestQueryHelperFactory.createQueryParser("blurb");
        Query luceneQuery = this.queryParser.parse("playing");
        CacheQuery cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(luceneQuery, new Class[0]);
        assert (cacheQuery.getResultSize() == 1);
    }

    public void testClear() throws ParseException {
        this.loadTestingData();
        Term navin = new Term("name", "navin");
        Term goat = new Term("name", "goat");
        Query[] queries = new Query[]{new TermQuery(goat), new TermQuery(navin)};
        Query luceneQuery = queries[0].combine(queries);
        CacheQuery cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(luceneQuery, new Class[0]);
        assert (cacheQuery.getResultSize() == 3) : "Expected 3, got " + cacheQuery.getResultSize();
        this.cache.clear();
        cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(luceneQuery, new Class[0]);
        assert (cacheQuery.getResultSize() == 0);
    }

    public void testTypeFiltering() throws ParseException {
        this.loadTestingData();
        this.queryParser = TestQueryHelperFactory.createQueryParser("blurb");
        Query luceneQuery = this.queryParser.parse("grass");
        CacheQuery cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(luceneQuery, new Class[0]);
        List found = cacheQuery.list();
        assert (found.size() == 2);
        assert (found.containsAll(Arrays.asList(this.person2, this.anotherGrassEater)));
        this.queryParser = TestQueryHelperFactory.createQueryParser("blurb");
        luceneQuery = this.queryParser.parse("grass");
        cacheQuery = Search.getSearchManager((Cache)this.cache).getQuery(luceneQuery, new Class[]{AnotherGrassEater.class});
        found = cacheQuery.list();
        assert (found.size() == 1);
        assert (found.get(0).equals(this.anotherGrassEater));
    }

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        FluentConfiguration cfg = LocalCacheTest.getDefaultClusteredConfig((Configuration.CacheMode)Configuration.CacheMode.LOCAL, (boolean)true).fluent();
        cfg.indexing().indexLocalOnly(Boolean.valueOf(false)).addProperty("hibernate.search.default.directory_provider", "ram");
        this.enhanceConfig(cfg);
        return TestCacheManagerFactory.createCacheManager((Configuration)cfg.build(), (boolean)true);
    }

    public void testEntityDiscovery() {
        this.assertIndexingKnows((Cache<Object, Object>)this.cache, new Class[0]);
        Person p = new Person();
        p.setName("Lucene developer");
        p.setAge(30);
        p.setBlurb("works best on weekends");
        this.cache.put((Object)p.getName(), (Object)p);
        this.assertIndexingKnows((Cache<Object, Object>)this.cache, Person.class);
    }

    private void assertIndexingKnows(Cache<Object, Object> cache, Class ... types) {
        ComponentRegistry cr = cache.getAdvancedCache().getComponentRegistry();
        SearchFactoryImplementor searchFactoryIntegrator = (SearchFactoryImplementor)cr.getComponent(SearchFactoryIntegrator.class);
        Assert.assertNotNull((Object)searchFactoryIntegrator);
        Map buildersIndexedEntities = searchFactoryIntegrator.getDocumentBuildersIndexedEntities();
        Assert.assertNotNull((Object)buildersIndexedEntities);
        Set keySet = buildersIndexedEntities.keySet();
        Assert.assertEquals((int)types.length, (int)keySet.size());
        Assert.assertTrue((boolean)keySet.containsAll(Arrays.asList(types)));
    }

    protected void loadTestingData() {
        this.person1 = new Person();
        this.person1.setName("Navin Surtani");
        this.person1.setBlurb("Likes playing WoW");
        this.person2 = new Person();
        this.person2.setName("Big Goat");
        this.person2.setBlurb("Eats grass");
        this.person3 = new Person();
        this.person3.setName("Mini Goat");
        this.person3.setBlurb("Eats cheese");
        this.person5 = new Person();
        this.person5.setName("Smelly Cat");
        this.person5.setBlurb("Eats fish");
        this.anotherGrassEater = new AnotherGrassEater("Another grass-eater", "Eats grass");
        this.cache.put((Object)this.key1, (Object)this.person1);
        this.cache.put((Object)this.key2, (Object)this.person2);
        this.cache.put((Object)this.key2, (Object)this.person2);
        this.cache.put((Object)this.key2, (Object)this.person2);
        this.cache.put((Object)this.key3, (Object)this.person3);
        this.cache.put((Object)this.anotherGrassEaterKey, (Object)this.anotherGrassEater);
    }

    protected void enhanceConfig(FluentConfiguration c) {
    }
}

