/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.tx;

import javax.transaction.TransactionManager;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.ProvidedId;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.helper.TestQueryHelperFactory;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.tx.TransactionalQueryTest")
public class TransactionalQueryTest
extends SingleCacheManagerTest {
    protected EmbeddedCacheManager m_cacheManager;
    private Cache<String, Session> m_cache;
    private TransactionManager m_transactionManager;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        Configuration c = this.getDefaultStandaloneConfig(true);
        c.fluent().indexing().indexLocalOnly(Boolean.valueOf(false)).addProperty("hibernate.search.default.directory_provider", "ram");
        this.m_cacheManager = TestCacheManagerFactory.createCacheManager((Configuration)c, (boolean)true);
        this.m_cache = this.m_cacheManager.getCache();
        this.m_transactionManager = this.m_cache.getAdvancedCache().getTransactionManager();
        return this.m_cacheManager;
    }

    @BeforeMethod
    public void initialize() throws Exception {
        this.m_transactionManager.begin();
        for (int i = 0; i < 100; ++i) {
            this.m_cache.put((Object)String.valueOf(i), (Object)new Session(String.valueOf(i)));
        }
        this.m_transactionManager.commit();
    }

    public void run() throws Exception {
        TestQueryHelperFactory.createCacheQuery(this.m_cache, "", "Id:2?");
        this.m_transactionManager.begin();
        this.m_cache.remove((Object)"50");
        this.m_transactionManager.commit();
        this.m_transactionManager.begin();
        this.m_cache.remove((Object)"200");
        this.m_transactionManager.commit();
    }

    @ProvidedId
    @Indexed(index="SessionIndex")
    public class Session {
        private String m_id;

        public Session(String id) {
            this.m_id = id;
        }

        @Field(name="Id")
        public String getId() {
            return this.m_id;
        }
    }
}

