/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.backend;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import org.hibernate.search.backend.TransactionContext;
import org.hibernate.search.backend.Work;
import org.hibernate.search.backend.WorkType;
import org.hibernate.search.spi.SearchFactoryIntegrator;
import org.hibernate.search.store.DirectoryProvider;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.marshall.MarshalledValue;
import org.infinispan.query.backend.KeyTransformationHandler;
import org.infinispan.query.backend.TransactionalEventTransactionContext;

public class QueryInterceptor
extends CommandInterceptor {
    private final SearchFactoryIntegrator searchFactory;
    private final ConcurrentHashMap<Class, Class> knownClasses = new ConcurrentHashMap();
    private final Lock mutating = new ReentrantLock();
    protected TransactionManager transactionManager;
    protected TransactionSynchronizationRegistry transactionSynchronizationRegistry;

    public QueryInterceptor(SearchFactoryIntegrator searchFactory) {
        this.searchFactory = searchFactory;
    }

    @Inject
    public void init(TransactionManager transactionManager, TransactionSynchronizationRegistry transactionSynchronizationRegistry) {
    }

    protected boolean shouldModifyIndexes(InvocationContext ctx) {
        return true;
    }

    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        Object toReturn = this.invokeNextInterceptor(ctx, (VisitableCommand)command);
        if (this.shouldModifyIndexes(ctx)) {
            Object key = command.getKey();
            Object value = this.extractValue(command.getValue());
            this.updateKnownTypesIfNeeded(value);
            CacheEntry entry = ctx.lookupEntry(key);
            if (entry.isCreated()) {
                this.log.debug((Object)"Entry is created");
                this.addToIndexes(value, this.extractValue(key));
            } else {
                this.log.debug((Object)"Entry is changed");
                this.updateIndexes(value, this.extractValue(key));
            }
        }
        return toReturn;
    }

    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        Object valueRemoved = this.invokeNextInterceptor(ctx, (VisitableCommand)command);
        if (command.isSuccessful() && !command.isNonExistent() && this.shouldModifyIndexes(ctx)) {
            Object value = this.extractValue(valueRemoved);
            this.updateKnownTypesIfNeeded(value);
            this.removeFromIndexes(value, this.extractValue(command.getKey()));
        }
        return valueRemoved;
    }

    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        Object valueReplaced = this.invokeNextInterceptor(ctx, (VisitableCommand)command);
        if (valueReplaced != null && this.shouldModifyIndexes(ctx)) {
            Object[] parameters = command.getParameters();
            Object p1 = this.extractValue(parameters[1]);
            Object p2 = this.extractValue(parameters[2]);
            this.updateKnownTypesIfNeeded(p1);
            this.updateKnownTypesIfNeeded(p2);
            Object key = this.extractValue(command.getKey());
            this.removeFromIndexes(p1, key);
            this.addToIndexes(p2, key);
        }
        return valueReplaced;
    }

    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        Object mapPut = this.invokeNextInterceptor(ctx, (VisitableCommand)command);
        if (this.shouldModifyIndexes(ctx)) {
            Map dataMap = command.getMap();
            for (Map.Entry entry : dataMap.entrySet()) {
                Object value = this.extractValue(entry.getValue());
                this.updateKnownTypesIfNeeded(value);
                this.addToIndexes(value, this.extractValue(entry.getKey()));
            }
        }
        return mapPut;
    }

    public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        Object returnValue = this.invokeNextInterceptor(ctx, (VisitableCommand)command);
        if (this.shouldModifyIndexes(ctx)) {
            if (this.trace) {
                this.log.trace((Object)"shouldModifyIndexes() is true and we can clear the indexes");
            }
            for (Class c : this.knownClasses.keySet()) {
                DirectoryProvider[] providers = this.searchFactory.getDirectoryProviders(c);
                Serializable id = null;
                if (providers == null || providers.length <= 0) continue;
                this.searchFactory.getWorker().performWork(new Work(c, id, WorkType.PURGE_ALL), (TransactionContext)new TransactionalEventTransactionContext(this.transactionManager, this.transactionSynchronizationRegistry));
            }
        }
        return returnValue;
    }

    protected void addToIndexes(Object value, Object key) {
        if (this.trace) {
            this.log.tracef("Adding to indexes for key [%s] and value [%s]", key, value);
        }
        if (value == null) {
            throw new NullPointerException("Cannot handle a null value!");
        }
        TransactionalEventTransactionContext transactionContext = new TransactionalEventTransactionContext(this.transactionManager, this.transactionSynchronizationRegistry);
        this.searchFactory.getWorker().performWork(new Work(value, (Serializable)((Object)KeyTransformationHandler.keyToString(key)), WorkType.ADD), (TransactionContext)transactionContext);
    }

    protected void removeFromIndexes(Object value, Object key) {
        if (value == null) {
            throw new NullPointerException("Cannot handle a null value!");
        }
        TransactionalEventTransactionContext transactionContext = new TransactionalEventTransactionContext(this.transactionManager, this.transactionSynchronizationRegistry);
        this.searchFactory.getWorker().performWork(new Work(value, (Serializable)((Object)KeyTransformationHandler.keyToString(key)), WorkType.DELETE), (TransactionContext)transactionContext);
    }

    protected void updateIndexes(Object value, Object key) {
        if (value == null) {
            throw new NullPointerException("Cannot handle a null value!");
        }
        TransactionalEventTransactionContext transactionContext = new TransactionalEventTransactionContext(this.transactionManager, this.transactionSynchronizationRegistry);
        this.searchFactory.getWorker().performWork(new Work(value, (Serializable)((Object)KeyTransformationHandler.keyToString(key)), WorkType.UPDATE), (TransactionContext)transactionContext);
    }

    private Object extractValue(Object wrappedValue) {
        if (wrappedValue instanceof MarshalledValue) {
            return ((MarshalledValue)wrappedValue).get();
        }
        return wrappedValue;
    }

    public void enableClasses(Class<?>[] classes) {
        if (classes == null || classes.length == 0) {
            return;
        }
        this.enableClassesIncrementally(classes, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enableClassesIncrementally(Class<?>[] classes, boolean locked) {
        ArrayList toAdd = null;
        for (Class<?> type : classes) {
            if (this.knownClasses.contains(type)) continue;
            if (toAdd == null) {
                toAdd = new ArrayList(classes.length);
            }
            toAdd.add(type);
        }
        if (toAdd == null) {
            return;
        }
        if (locked) {
            Set existingClasses = this.knownClasses.keySet();
            int index = existingClasses.size();
            Class[] all = existingClasses.toArray(new Class[existingClasses.size() + toAdd.size()]);
            for (Class clazz : toAdd) {
                all[index++] = clazz;
            }
            this.searchFactory.addClasses(all);
            for (Class clazz : toAdd) {
                this.knownClasses.put(clazz, clazz);
            }
        } else {
            this.mutating.lock();
            try {
                this.enableClassesIncrementally(classes, true);
            }
            finally {
                this.mutating.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateKnownTypesIfNeeded(Object value) {
        Class<?> potentialNewType;
        if (value != null && !this.knownClasses.contains(potentialNewType = value.getClass())) {
            this.mutating.lock();
            try {
                this.enableClassesIncrementally(new Class[]{potentialNewType}, true);
            }
            finally {
                this.mutating.unlock();
            }
        }
    }
}

