/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.hibernate.search.query.engine.impl.EntityInfoImpl;
import org.hibernate.search.query.engine.spi.DocumentExtractor;
import org.hibernate.search.query.engine.spi.EntityInfo;
import org.hibernate.search.query.engine.spi.HSQuery;
import org.infinispan.AdvancedCache;
import org.infinispan.query.impl.LazyIterator;
import org.infinispan.query.test.Person;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class LazyIteratorTest {
    AdvancedCache<String, Person> cache;
    LazyIterator iterator = null;
    int fetchSize = 1;
    StringBuilder builder;
    Map<String, Person> dummyDataMap;
    Person[] persons;
    List<String> keyList;
    private DocumentExtractor extractor;

    @BeforeTest
    public void setUpBeforeTest() throws Exception {
        this.dummyDataMap = new HashMap<String, Person>();
        this.keyList = new ArrayList<String>();
        this.persons = new Person[11];
        for (int i = 1; i < 11; ++i) {
            Person person = new Person();
            person.setBlurb("cat");
            this.dummyDataMap.put("key" + i, person);
            this.keyList.add("S:key" + i);
            this.persons[i] = person;
        }
    }

    @BeforeMethod
    public void setUp() throws IOException {
        this.cache = (AdvancedCache)EasyMock.createMock(AdvancedCache.class);
        EasyMock.expect((Object)this.cache.get(EasyMock.anyObject())).andAnswer((IAnswer)new IAnswer<Person>(){

            public Person answer() throws Throwable {
                String key = EasyMock.getCurrentArguments()[0].toString();
                return LazyIteratorTest.this.dummyDataMap.get(key);
            }
        }).anyTimes();
        EasyMock.expect((Object)this.cache.getClassLoader()).andReturn((Object)Thread.currentThread().getContextClassLoader()).anyTimes();
        this.extractor = (DocumentExtractor)EasyMock.createStrictMock(DocumentExtractor.class);
        HSQuery hsQuery = (HSQuery)EasyMock.createMock(HSQuery.class);
        EasyMock.expect((Object)hsQuery.queryDocumentExtractor()).andReturn((Object)this.extractor).once();
        EasyMock.expect((Object)hsQuery.queryResultSize()).andReturn((Object)this.dummyDataMap.size()).once();
        EasyMock.expect((Object)this.extractor.extract(EasyMock.anyInt())).andAnswer((IAnswer)new IAnswer<EntityInfo>(){

            public EntityInfo answer() throws Throwable {
                int index = (Integer)EasyMock.getCurrentArguments()[0];
                String keyString = LazyIteratorTest.this.keyList.get(index);
                return new EntityInfoImpl(Person.class, keyString, (Serializable)((Object)keyString), (Object[])new String[0]);
            }
        }).anyTimes();
        this.extractor.close();
        EasyMock.expectLastCall().once();
        EasyMock.replay((Object[])new Object[]{this.cache, this.extractor, hsQuery});
        this.iterator = new LazyIterator(hsQuery, this.cache, this.fetchSize);
    }

    @AfterMethod(alwaysRun=false)
    public void tearDown() {
        this.iterator = null;
        EasyMock.verify((Object[])new Object[]{this.extractor});
    }

    public void testJumpToResult() throws IndexOutOfBoundsException {
        this.iterator.jumpToResult(0);
        assert (this.iterator.isFirst());
        this.iterator.jumpToResult(1);
        assert (this.iterator.isAfterFirst());
        this.iterator.jumpToResult(9);
        assert (this.iterator.isLast());
        this.iterator.jumpToResult(8);
        assert (this.iterator.isBeforeLast());
        this.iterator.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expectedExceptions={IndexOutOfBoundsException.class})
    public void testOutOfBoundsBelow() {
        try {
            this.iterator.jumpToResult(-1);
        }
        finally {
            this.iterator.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expectedExceptions={IndexOutOfBoundsException.class})
    public void testOutOfBoundsAbove() {
        try {
            this.iterator.jumpToResult(this.keyList.size() + 1);
        }
        finally {
            this.iterator.close();
        }
    }

    public void testFirst() {
        assert (this.iterator.isFirst()) : "We should be pointing at the first element";
        Object next = this.iterator.next();
        assert (next == this.persons[1]);
        assert (!this.iterator.isFirst());
        this.iterator.first();
        assert (this.iterator.isFirst()) : "We should be pointing at the first element";
        next = this.iterator.next();
        assert (next == this.persons[1]);
        assert (!this.iterator.isFirst());
        this.iterator.close();
    }

    public void testLast() {
        this.iterator.last();
        assert (this.iterator.isLast());
        this.iterator.first();
        assert (!this.iterator.isLast());
        this.iterator.close();
    }

    public void testAfterFirst() {
        this.iterator.afterFirst();
        assert (this.iterator.isAfterFirst());
        Object previous = this.iterator.previous();
        assert (previous == this.persons[2]);
        assert (!this.iterator.isAfterFirst());
        this.iterator.close();
    }

    public void testBeforeLast() {
        this.iterator.beforeLast();
        assert (this.iterator.isBeforeLast());
        Object next = this.iterator.next();
        assert (next == this.persons[9]);
        assert (!this.iterator.isBeforeLast());
        this.iterator.close();
    }

    public void testIsFirst() {
        this.iterator.first();
        assert (this.iterator.isFirst());
        this.iterator.next();
        assert (!this.iterator.isFirst());
        this.iterator.close();
    }

    public void testIsLast() {
        this.iterator.last();
        assert (this.iterator.isLast());
        this.iterator.previous();
        assert (!this.iterator.isLast());
        this.iterator.close();
    }

    public void testIsAfterFirst() {
        this.iterator.afterFirst();
        assert (this.iterator.isAfterFirst());
        this.iterator.previous();
        assert (!this.iterator.isAfterFirst());
        this.iterator.close();
    }

    public void testIsBeforeLast() {
        this.iterator.beforeLast();
        assert (this.iterator.isBeforeLast());
        this.iterator.close();
    }

    public void testNextAndHasNext() {
        this.iterator.first();
        this.builder = new StringBuilder();
        for (int i = 1; i <= 10; ++i) {
            this.builder.delete(0, 4);
            this.builder.append("key");
            this.builder.append(i);
            String keyString = this.builder.toString();
            Object expectedValue = this.cache.get((Object)keyString);
            assert (this.iterator.hasNext());
            Object next = this.iterator.next();
            assert (expectedValue == next);
        }
        assert (!this.iterator.hasNext());
        this.iterator.close();
    }

    public void testPreviousAndHasPrevious() {
        this.iterator.last();
        this.builder = new StringBuilder();
        for (int i = 10; i >= 1; --i) {
            this.builder.delete(0, 5);
            this.builder.append("key");
            this.builder.append(i);
            String keyString = this.builder.toString();
            Object expectedValue = this.cache.get((Object)keyString);
            assert (this.iterator.hasPrevious());
            Object previous = this.iterator.previous();
            assert (expectedValue == previous);
        }
        assert (!this.iterator.hasPrevious());
        this.iterator.close();
    }

    public void testNextIndex() {
        this.iterator.first();
        assert (this.iterator.nextIndex() == 1);
        this.iterator.last();
        assert (this.iterator.nextIndex() == 10);
        this.iterator.close();
    }

    public void testPreviousIndex() {
        this.iterator.first();
        assert (this.iterator.previousIndex() == -1);
        this.iterator.last();
        assert (this.iterator.previousIndex() == 8);
        this.iterator.close();
    }
}

