/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl;

import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.hibernate.search.cfg.SearchConfiguration;
import org.hibernate.search.spi.SearchFactoryBuilder;
import org.hibernate.search.spi.SearchFactoryIntegrator;
import org.infinispan.config.Configuration;
import org.infinispan.config.FluentConfiguration;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.interceptors.DistLockingInterceptor;
import org.infinispan.interceptors.InterceptorChain;
import org.infinispan.interceptors.LockingInterceptor;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.lifecycle.AbstractModuleLifecycle;
import org.infinispan.query.backend.LocalQueryInterceptor;
import org.infinispan.query.backend.QueryInterceptor;
import org.infinispan.query.backend.SearchableCacheConfiguration;
import org.infinispan.query.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class LifecycleManager
extends AbstractModuleLifecycle {
    private static final Log log = (Log)LogFactory.getLog(LifecycleManager.class, Log.class);
    private final Map<String, SearchFactoryIntegrator> searchFactoriesToShutdown = new TreeMap<String, SearchFactoryIntegrator>();

    public void cacheStarting(ComponentRegistry cr, Configuration configuration, String cacheName) {
        Configuration cfg = (Configuration)cr.getComponent(Configuration.class);
        if (cfg.isIndexingEnabled()) {
            log.registeringQueryInterceptor();
            SearchFactoryIntegrator searchFactory = this.getSearchFactory((Properties)cfg.getIndexingProperties(), cr);
            this.createQueryInterceptorIfNeeded(cr, cfg, searchFactory);
        }
    }

    private void createQueryInterceptorIfNeeded(ComponentRegistry cr, Configuration cfg, SearchFactoryIntegrator searchFactory) {
        QueryInterceptor queryInterceptor = (QueryInterceptor)((Object)cr.getComponent(QueryInterceptor.class));
        if (queryInterceptor == null) {
            queryInterceptor = this.buildQueryInterceptor(cfg, searchFactory);
            cr.registerComponent((Object)queryInterceptor, QueryInterceptor.class);
            FluentConfiguration.CustomInterceptorPosition customInterceptorPosition = cfg.fluent().customInterceptors().add((CommandInterceptor)queryInterceptor);
            if (cfg.getCacheMode().isDistributed()) {
                customInterceptorPosition.after(DistLockingInterceptor.class);
            } else {
                customInterceptorPosition.after(LockingInterceptor.class);
            }
        }
    }

    private QueryInterceptor buildQueryInterceptor(Configuration cfg, SearchFactoryIntegrator searchFactory) {
        if (cfg.isIndexLocalOnly()) {
            return new LocalQueryInterceptor(searchFactory);
        }
        return new QueryInterceptor(searchFactory);
    }

    public void cacheStarted(ComponentRegistry cr, String cacheName) {
        if (!this.verifyChainContainsQueryInterceptor(cr)) {
            throw new IllegalStateException("It was expected to find the Query interceptor registered in the InterceptorChain but it wasn't found");
        }
    }

    private boolean verifyChainContainsQueryInterceptor(ComponentRegistry cr) {
        Configuration cfg = (Configuration)cr.getComponent(Configuration.class);
        if (cfg.isIndexingEnabled()) {
            InterceptorChain interceptorChain = (InterceptorChain)cr.getComponent(InterceptorChain.class);
            CommandInterceptor chainElement = interceptorChain.getFirstInChain();
            if (chainElement instanceof QueryInterceptor) {
                return true;
            }
            while (chainElement.hasNext()) {
                if (!((chainElement = chainElement.getNext()) instanceof QueryInterceptor)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private SearchFactoryIntegrator getSearchFactory(Properties indexingProperties, ComponentRegistry cr) {
        SearchFactoryIntegrator searchFactory = (SearchFactoryIntegrator)cr.getComponent(SearchFactoryIntegrator.class);
        if (searchFactory == null) {
            SearchableCacheConfiguration config = new SearchableCacheConfiguration(new Class[0], indexingProperties);
            searchFactory = new SearchFactoryBuilder().configuration((SearchConfiguration)config).buildSearchFactory();
            cr.registerComponent((Object)searchFactory, SearchFactoryIntegrator.class);
        }
        return searchFactory;
    }

    public void cacheStopping(ComponentRegistry cr, String cacheName) {
        SearchFactoryIntegrator searchFactoryImplementor = (SearchFactoryIntegrator)cr.getComponent(SearchFactoryIntegrator.class);
        if (searchFactoryImplementor != null) {
            this.searchFactoriesToShutdown.put(cacheName, searchFactoryImplementor);
        }
    }

    public void cacheStopped(ComponentRegistry cr, String cacheName) {
        SearchFactoryIntegrator searchFactoryIntegrator = this.searchFactoriesToShutdown.remove(cacheName);
        if (searchFactoryIntegrator != null) {
            searchFactoryIntegrator.close();
        }
    }
}

