/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.cacheloaders;

import java.util.List;
import junit.framework.Assert;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Query;
import org.hibernate.search.spi.SearchFactoryIntegrator;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.loaders.CacheLoaderConfig;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.CacheLoaderManager;
import org.infinispan.loaders.CacheStore;
import org.infinispan.loaders.dummy.DummyInMemoryCacheStore;
import org.infinispan.manager.CacheContainer;
import org.infinispan.query.Search;
import org.infinispan.query.SearchManager;
import org.infinispan.query.helper.TestQueryHelperFactory;
import org.infinispan.query.indexedembedded.City;
import org.infinispan.query.indexedembedded.Country;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.cacheloaders.EntryActivatingTest")
public class EntryActivatingTest
extends AbstractInfinispanTest {
    Cache<String, Country> cache;
    CacheStore store;
    Configuration cfg;
    CacheContainer cm;
    SearchManager search;
    QueryParser queryParser = TestQueryHelperFactory.createQueryParser("countryName");

    @BeforeTest
    public void setUp() {
        this.recreateCacheManager();
    }

    @AfterTest
    public void tearDown() {
        TestingUtil.killCacheManagers((CacheContainer[])new CacheContainer[]{this.cm});
    }

    public void testPersistence() throws CacheLoaderException, ParseException {
        this.verifyFullTextHasMatches(0);
        Country italy = new Country();
        italy.countryName = "Italy";
        this.cache.put((Object)"IT", (Object)italy);
        assert (!this.store.containsKey((Object)"IT"));
        this.verifyFullTextHasMatches(1);
        this.cache.evict((Object)"IT");
        assert (this.store.containsKey((Object)"IT"));
        InternalCacheEntry internalCacheEntry = this.cache.getAdvancedCache().getDataContainer().get((Object)"IT");
        assert (internalCacheEntry == null);
        this.verifyFullTextHasMatches(1);
        Country country = (Country)this.cache.get((Object)"IT");
        assert (country != null);
        assert ("Italy".equals(country.countryName));
        this.verifyFullTextHasMatches(1);
        this.cache.stop();
        assert (((SearchFactoryIntegrator)this.search.getSearchFactory()).isStopped());
        TestingUtil.killCacheManagers((CacheContainer[])new CacheContainer[]{this.cm});
        this.recreateCacheManager();
        this.verifyFullTextHasMatches(0);
    }

    private void recreateCacheManager() {
        this.cfg = new Configuration().fluent().loaders().passivation(Boolean.valueOf(true)).addCacheLoader(new CacheLoaderConfig[]{new DummyInMemoryCacheStore.Cfg().storeName(((Object)((Object)this)).getClass().getName()).purgeOnStartup(Boolean.valueOf(false))}).preload(Boolean.valueOf(true)).indexing().addProperty("hibernate.search.default.directory_provider", "ram").addProperty("hibernate.search.lucene_version", "LUCENE_CURRENT").build();
        this.cm = TestCacheManagerFactory.createCacheManager((Configuration)this.cfg, (boolean)true);
        this.cache = this.cm.getCache();
        this.store = ((CacheLoaderManager)TestingUtil.extractComponent(this.cache, CacheLoaderManager.class)).getCacheStore();
        this.search = Search.getSearchManager(this.cache);
    }

    private void verifyFullTextHasMatches(int i) throws ParseException {
        Query query = this.queryParser.parse("Italy");
        List list = this.search.getQuery(query, new Class[]{Country.class, City.class}).list();
        Assert.assertEquals((int)i, (int)list.size());
    }
}

