/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.indexedembedded;

import java.util.List;
import org.apache.lucene.search.Query;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.Search;
import org.infinispan.query.SearchManager;
import org.infinispan.query.indexedembedded.Book;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.BooksExampleTests")
public class BooksExampleTests
extends SingleCacheManagerTest {
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        Configuration c = this.getDefaultStandaloneConfig(true);
        c.fluent().indexing().indexLocalOnly(Boolean.valueOf(false)).addProperty("hibernate.search.default.directory_provider", "ram").addProperty("hibernate.search.lucene_version", "LUCENE_CURRENT");
        return TestCacheManagerFactory.createCacheManager((Configuration)c, (boolean)true);
    }

    @Test
    public void searchOnEmptyIndex() {
        this.cache.put((Object)"1", (Object)new Book("Seam in Action", "Dan Allen", "Manning"));
        this.cache.put((Object)"2", (Object)new Book("Hibernate Search in Action", "Emmanuel Bernard and John Griffin", "Manning"));
        this.cache.put((Object)"3", (Object)new Book("Megaprogramming Ruby", "Paolo Perrotta", "The Pragmatic Programmers"));
        SearchManager qf = Search.getSearchManager((Cache)this.cache);
        Query query = qf.buildQueryBuilderForClass(Book.class).get().phrase().onField("title").sentence("in action").createQuery();
        List list = qf.getQuery(query, new Class[0]).list();
        assert (list.size() == 2);
    }
}

