/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.clustered;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.hibernate.search.SearchException;
import org.infinispan.Cache;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.query.clustered.ClusteredQueryCommand;
import org.infinispan.query.clustered.QueryResponse;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.rpc.ResponseMode;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;

public class ClusteredQueryInvoker {
    private final RpcManager rpcManager;
    private final Cache localCacheInstance;
    private final Address myAddress;
    private ExecutorService asyncExecutor;

    ClusteredQueryInvoker(Cache localCacheInstance, ExecutorService asyncExecutor) {
        this.asyncExecutor = asyncExecutor;
        this.rpcManager = (RpcManager)localCacheInstance.getAdvancedCache().getComponentRegistry().getLocalComponent(RpcManager.class);
        this.localCacheInstance = localCacheInstance;
        this.myAddress = localCacheInstance.getAdvancedCache().getRpcManager().getAddress();
    }

    public Object getValue(int doc, Address address, UUID queryId) {
        ClusteredQueryCommand clusteredQuery = ClusteredQueryCommand.retrieveKeyFromLazyQuery(this.localCacheInstance, queryId, doc);
        if (address.equals(this.myAddress)) {
            Future<QueryResponse> localResponse = this.localInvoke(clusteredQuery);
            try {
                return localResponse.get().getFetchedValue();
            }
            catch (InterruptedException e) {
                throw new SearchException("interrupted while searching locally", (Throwable)e);
            }
            catch (ExecutionException e) {
                throw new SearchException("Exception while searching locally", (Throwable)e);
            }
        }
        ArrayList<Address> addresss = new ArrayList<Address>(1);
        addresss.add(address);
        Map responses = this.rpcManager.invokeRemotely(addresss, (ReplicableCommand)clusteredQuery, ResponseMode.SYNCHRONOUS, 10000L);
        List<QueryResponse> objects = this.cast(responses);
        return objects.get(0).getFetchedValue();
    }

    public List<QueryResponse> broadcast(ClusteredQueryCommand clusteredQuery) {
        QueryResponse localReturnValue;
        Future<QueryResponse> localResponse = this.localInvoke(clusteredQuery);
        Map responses = this.rpcManager.invokeRemotely(null, (ReplicableCommand)clusteredQuery, ResponseMode.SYNCHRONOUS, 10000L);
        List<QueryResponse> objects = this.cast(responses);
        try {
            localReturnValue = localResponse.get();
        }
        catch (InterruptedException e1) {
            throw new SearchException("interrupted while searching locally", (Throwable)e1);
        }
        catch (ExecutionException e1) {
            throw new SearchException("Exception while searching locally", (Throwable)e1);
        }
        objects.add(localReturnValue);
        return objects;
    }

    private Future<QueryResponse> localInvoke(ClusteredQueryCommand clusteredQuery) {
        ClusteredQueryCallable clusteredQueryCallable = new ClusteredQueryCallable(clusteredQuery, this.localCacheInstance);
        return this.asyncExecutor.submit(clusteredQueryCallable);
    }

    private List<QueryResponse> cast(Map<Address, Response> responses) {
        LinkedList<QueryResponse> objects = new LinkedList<QueryResponse>();
        for (Map.Entry<Address, Response> pair : responses.entrySet()) {
            Response resp = pair.getValue();
            if (resp instanceof SuccessfulResponse) {
                QueryResponse response = (QueryResponse)((SuccessfulResponse)resp).getResponseValue();
                objects.add(response);
                continue;
            }
            throw new SearchException("Unexpected response: " + resp);
        }
        return objects;
    }

    private static final class ClusteredQueryCallable
    implements Callable<QueryResponse> {
        private final ClusteredQueryCommand clusteredQuery;
        private final Cache localInstance;

        ClusteredQueryCallable(ClusteredQueryCommand clusteredQuery, Cache localInstance) {
            this.clusteredQuery = clusteredQuery;
            this.localInstance = localInstance;
        }

        @Override
        public QueryResponse call() throws Exception {
            try {
                return this.clusteredQuery.perform(this.localInstance);
            }
            catch (Throwable e) {
                e.printStackTrace();
                throw new Exception(e.getMessage());
            }
        }
    }
}

