/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.helper;

import junit.framework.Assert;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.Version;
import org.hibernate.search.spi.SearchFactoryIntegrator;
import org.infinispan.Cache;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.Search;
import org.infinispan.query.SearchManager;

public class TestQueryHelperFactory {
    public static final Analyzer STANDARD_ANALYZER = new StandardAnalyzer(TestQueryHelperFactory.getLuceneVersion());

    public static QueryParser createQueryParser(String defaultFieldName) {
        return new QueryParser(TestQueryHelperFactory.getLuceneVersion(), defaultFieldName, STANDARD_ANALYZER);
    }

    public static Version getLuceneVersion() {
        return Version.LUCENE_30;
    }

    public static CacheQuery createCacheQuery(Cache m_cache, String fieldName, String searchString) throws ParseException {
        QueryParser qp = TestQueryHelperFactory.createQueryParser(fieldName);
        Query parsedQuery = qp.parse(searchString);
        SearchManager queryFactory = Search.getSearchManager((Cache)m_cache);
        CacheQuery cacheQuery = queryFactory.getQuery(parsedQuery, new Class[0]);
        return cacheQuery;
    }

    public static SearchFactoryIntegrator extractSearchFactory(Cache cache) {
        ComponentRegistry componentRegistry = cache.getAdvancedCache().getComponentRegistry();
        SearchFactoryIntegrator component = (SearchFactoryIntegrator)componentRegistry.getComponent(SearchFactoryIntegrator.class);
        Assert.assertNotNull((Object)component);
        return component;
    }
}

