/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.config;

import java.io.IOException;
import java.util.Map;
import org.infinispan.config.Configuration;
import org.infinispan.config.InfinispanConfiguration;
import org.infinispan.test.AbstractInfinispanTest;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="config.parsing.QueryParsingTest")
public class QueryParsingTest
extends AbstractInfinispanTest {
    public void testConfigurationFileParsing() throws IOException {
        InfinispanConfiguration cfg = InfinispanConfiguration.newInfinispanConfiguration((String)"configuration-parsing-test.xml", (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        cfg.parseGlobalConfiguration();
        Configuration defaultConfiguration = cfg.parseDefaultConfiguration();
        defaultConfiguration.assertValid();
        assert (defaultConfiguration.getIndexingProperties().size() == 0);
        assert (!defaultConfiguration.isIndexingEnabled());
        Map namedConfigurations = cfg.parseNamedConfigurations();
        Configuration simpleCfg = (Configuration)namedConfigurations.get("simple");
        simpleCfg.assertValid();
        assert (!simpleCfg.isIndexingEnabled());
        assert (simpleCfg.getIndexingProperties().size() == 0);
        Configuration memoryCfg = (Configuration)namedConfigurations.get("memory-searchable");
        memoryCfg.assertValid();
        assert (memoryCfg.isIndexingEnabled());
        assert (memoryCfg.getIndexingProperties().size() == 1);
        assert (memoryCfg.getIndexingProperties().getProperty("hibernate.search.default.directory_provider").equals("ram"));
        Configuration diskCfg = (Configuration)namedConfigurations.get("disk-searchable");
        diskCfg.assertValid();
        assert (diskCfg.isIndexingEnabled());
        assert (diskCfg.getIndexingProperties().size() == 2);
        assert (diskCfg.getIndexingProperties().getProperty("hibernate.search.default.directory_provider").equals("filesystem"));
        assert (diskCfg.getIndexingProperties().getProperty("hibernate.search.cats.exclusive_index_use").equals("true"));
    }

    public void testConfigurationFileParsingWithDefaultEnabled() throws IOException {
        InfinispanConfiguration cfg = InfinispanConfiguration.newInfinispanConfiguration((String)"configuration-parsing-test-enbledInDefault.xml", (ClassLoader)((Object)((Object)this)).getClass().getClassLoader());
        cfg.parseGlobalConfiguration();
        Configuration defaultConfiguration = cfg.parseDefaultConfiguration();
        defaultConfiguration.assertValid();
        assert (defaultConfiguration.getIndexingProperties().size() == 1);
        assert (defaultConfiguration.isIndexingEnabled());
        assert (defaultConfiguration.getIndexingProperties().getProperty("hibernate.search.default.directory_provider").equals("someDefault"));
        Map namedConfigurations = cfg.parseNamedConfigurations();
        Configuration nonSearchableCfg = (Configuration)namedConfigurations.get("not-searchable");
        nonSearchableCfg.assertValid();
        assert (!nonSearchableCfg.isIndexingEnabled());
        Configuration simpleCfg = (Configuration)namedConfigurations.get("simple");
        simpleCfg.assertValid();
        assert (!simpleCfg.isIndexingEnabled());
        assert (simpleCfg.getIndexingProperties().size() == 0);
        Configuration memoryCfg = (Configuration)namedConfigurations.get("memory-searchable");
        memoryCfg.assertValid();
        assert (memoryCfg.isIndexingEnabled());
        assert (!memoryCfg.isIndexLocalOnly());
        assert (memoryCfg.getIndexingProperties().size() == 1);
        assert (memoryCfg.getIndexingProperties().getProperty("hibernate.search.default.directory_provider").equals("ram"));
        Configuration diskCfg = (Configuration)namedConfigurations.get("disk-searchable");
        diskCfg.assertValid();
        assert (diskCfg.isIndexingEnabled());
        assert (diskCfg.isIndexLocalOnly());
        assert (diskCfg.getIndexingProperties().size() == 2);
        assert (diskCfg.getIndexingProperties().getProperty("hibernate.search.default.directory_provider").equals("filesystem"));
        assert (diskCfg.getIndexingProperties().getProperty("hibernate.search.cats.exclusive_index_use").equals("true"));
    }
}

