/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.search.query.engine.spi.EntityInfo;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.query.backend.KeyTransformationHandler;

public class EntityLoader {
    private final AdvancedCache<?, ?> cache;
    private final KeyTransformationHandler keyTransformationHandler;

    public EntityLoader(Cache<?, ?> cache, KeyTransformationHandler keyTransformationHandler) {
        this.keyTransformationHandler = keyTransformationHandler;
        this.cache = cache.getAdvancedCache();
    }

    public Object load(EntityInfo entityInfo) {
        Object cacheKey = this.keyTransformationHandler.stringToKey(entityInfo.getId().toString(), this.cache.getClassLoader());
        return this.cache.get(cacheKey);
    }

    public List<Object> load(EntityInfo ... entityInfos) {
        int size = entityInfos.length;
        ArrayList<Object> list = new ArrayList<Object>(size);
        for (EntityInfo e : entityInfos) {
            list.add(this.load(e));
        }
        return list;
    }
}

