/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.clustered;

import java.util.LinkedList;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import org.hibernate.search.query.engine.spi.DocumentExtractor;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.query.backend.KeyTransformationHandler;
import org.infinispan.query.clustered.commandworkers.QueryExtractorUtil;
import org.infinispan.query.logging.Log;
import org.infinispan.util.concurrent.ConcurrentMapFactory;
import org.infinispan.util.logging.LogFactory;

public class QueryBox {
    private final ConcurrentMap<UUID, DocumentExtractor> queries = ConcurrentMapFactory.makeConcurrentMap();
    private final LinkedList<UUID> ageOrderedQueries = new LinkedList();
    private static final int BOX_LIMIT = 3000;
    private final UUID myId = UUID.randomUUID();
    private AdvancedCache cache;
    private static final Log log = (Log)LogFactory.getLog(QueryBox.class, Log.class);
    private KeyTransformationHandler keyTransformationHandler;

    public Object getValue(UUID queryUuid, int docIndex) {
        this.touch(queryUuid);
        DocumentExtractor extractor = (DocumentExtractor)this.queries.get(queryUuid);
        if (extractor == null) {
            throw new IllegalStateException("Query not found!");
        }
        Object key = QueryExtractorUtil.extractKey(extractor, (Cache)this.cache, this.keyTransformationHandler, docIndex);
        return this.cache.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void touch(UUID id) {
        LinkedList<UUID> linkedList = this.ageOrderedQueries;
        synchronized (linkedList) {
            this.ageOrderedQueries.remove(id);
            this.ageOrderedQueries.addFirst(id);
        }
    }

    public void kill(UUID id) {
        DocumentExtractor extractor = (DocumentExtractor)this.queries.remove(id);
        this.ageOrderedQueries.remove(id);
        if (extractor != null) {
            extractor.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void put(UUID id, DocumentExtractor extractor) {
        LinkedList<UUID> linkedList = this.ageOrderedQueries;
        synchronized (linkedList) {
            if (this.ageOrderedQueries.size() >= 3000) {
                this.ageOrderedQueries.removeLast();
            }
            this.ageOrderedQueries.add(id);
        }
        this.queries.put(id, extractor);
    }

    public UUID getMyId() {
        return this.myId;
    }

    public void setCache(AdvancedCache cache) {
        this.cache = cache;
        this.keyTransformationHandler = KeyTransformationHandler.getInstance(cache.getAdvancedCache());
    }
}

