/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.cacheloaders;

import java.io.File;
import java.io.Serializable;
import java.util.List;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.ProvidedId;
import org.hibernate.search.annotations.Store;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.IndexingConfigurationBuilder;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.Search;
import org.infinispan.query.SearchManager;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class InconsistentIndexesAfterRestartTest
extends AbstractInfinispanTest {
    private static String TMP_DIR;

    @Test
    public void testPutSearchablePersistentWithoutBatchingWithoutTran() throws Exception {
        this.testPutTwice(false, false);
    }

    @Test
    public void testPutSearchablePersistentWithBatchingWithoutTran() throws Exception {
        this.testPutTwice(true, false);
    }

    @Test
    public void testPutSearchablePersistentWithBatchingInTran() throws Exception {
        this.testPutTwice(true, true);
    }

    private void testPutTwice(boolean batching, boolean inTran) throws Exception {
        this.testPutOperation(batching, inTran);
        this.testPutOperation(batching, inTran);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testPutOperation(boolean batching, boolean inTran) throws Exception {
        EmbeddedCacheManager cacheManager = this.getCacheManager(batching);
        try {
            Cache c = cacheManager.getCache();
            if (inTran) {
                c.getAdvancedCache().getTransactionManager().begin();
            }
            c.put((Object)"key1", (Object)new SEntity(1L, "name1", "surname1"));
            if (inTran) {
                c.getAdvancedCache().getTransactionManager().commit();
            }
            Assert.assertEquals((int)this.searchByName("name1", c).size(), (int)1, (String)"should be 1, even repeating this");
        }
        finally {
            cacheManager.stop();
        }
    }

    private EmbeddedCacheManager getCacheManager(boolean batchingEnabled) throws Exception {
        IndexingConfigurationBuilder cfgBuilder = new ConfigurationBuilder().loaders().passivation(false).preload(false).addFileCacheStore().location(TMP_DIR + File.separator + "cacheStore").fetchPersistentState(true).purgeOnStartup(false).indexing().enable().indexLocalOnly(true).addProperty("hibernate.search.default.directory_provider", "filesystem").addProperty("hibernate.search.default.indexBase", TMP_DIR + File.separator + "idx");
        if (batchingEnabled) {
            cfgBuilder.invocationBatching().enable();
        } else {
            cfgBuilder.invocationBatching().disable();
        }
        Configuration configuration = cfgBuilder.build();
        DefaultCacheManager manager = new DefaultCacheManager(configuration);
        return manager;
    }

    private List searchByName(String name, Cache c) {
        SearchManager sm = Search.getSearchManager((Cache)c);
        CacheQuery q = sm.getQuery(SEntity.searchByName(name), new Class[]{SEntity.class});
        int resultSize = q.getResultSize();
        List l = q.list();
        assert (l.size() == resultSize);
        return q.list();
    }

    @BeforeClass
    protected void setUpTempDir() {
        TMP_DIR = TestingUtil.tmpDirectory((AbstractInfinispanTest)this);
        new File(TMP_DIR).mkdirs();
    }

    @AfterClass(alwaysRun=true)
    protected void clearTempDir() {
        TestingUtil.recursiveFileRemove((String)TMP_DIR);
    }

    @ProvidedId
    @Indexed
    public static class SEntity
    implements Serializable {
        public static final String IDX_NAME = "name";
        public static final String IDX_SURNAME = "surname";
        private final long id;
        @Field(store=Store.YES)
        private final String name;
        @Field(store=Store.YES)
        private final String surname;

        public SEntity(long id, String name, String surname) {
            this.id = id;
            this.name = name;
            this.surname = surname;
        }

        public long getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getSurname() {
            return this.surname;
        }

        public String toString() {
            return "SEntity{id=" + this.id + ", name='" + this.name + '\'' + ", surname='" + this.surname + '\'' + '}';
        }

        public static Query searchByName(String name) {
            BooleanQuery query = new BooleanQuery();
            query.add((Query)new TermQuery(new Term(IDX_NAME, name.toLowerCase())), BooleanClause.Occur.MUST);
            return query;
        }
    }
}

