/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.config;

import java.io.IOException;
import org.infinispan.Cache;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.Search;
import org.infinispan.query.SearchManager;
import org.infinispan.query.backend.QueryInterceptor;
import org.infinispan.query.impl.ComponentRegistryUtils;
import org.infinispan.test.TestingUtil;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="config.parsing.QueryParsingTest")
public class DefaultCacheInheritancePreventedTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void verifyIndexDisabledCorrectly() throws IOException {
        DefaultCacheManager cacheManager = new DefaultCacheManager("configuration-parsing-test-enbledInDefault.xml");
        try {
            this.assertIndexingEnabled((Cache<Object, Object>)cacheManager.getCache(), true);
            this.assertIndexingEnabled((Cache<Object, Object>)cacheManager.getCache("simple"), true);
            this.assertIndexingEnabled((Cache<Object, Object>)cacheManager.getCache("not-searchable"), false);
            this.assertIndexingEnabled((Cache<Object, Object>)cacheManager.getCache("memory-searchable"), true);
            this.assertIndexingEnabled((Cache<Object, Object>)cacheManager.getCache("disk-searchable"), true);
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{cacheManager});
            throw throwable;
        }
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{cacheManager});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void verifyIndexEnabledCorrectly() throws IOException {
        DefaultCacheManager cacheManager = new DefaultCacheManager("configuration-parsing-test.xml");
        try {
            this.assertIndexingEnabled((Cache<Object, Object>)cacheManager.getCache(), false);
            this.assertIndexingEnabled((Cache<Object, Object>)cacheManager.getCache("simple"), false);
            this.assertIndexingEnabled((Cache<Object, Object>)cacheManager.getCache("memory-searchable"), true);
            this.assertIndexingEnabled((Cache<Object, Object>)cacheManager.getCache("disk-searchable"), true);
        }
        catch (Throwable throwable) {
            TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{cacheManager});
            throw throwable;
        }
        TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{cacheManager});
    }

    private void assertIndexingEnabled(Cache<Object, Object> cache, boolean expected) {
        SearchManager searchManager = null;
        try {
            searchManager = Search.getSearchManager(cache);
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        if (expected && searchManager == null) {
            Assert.fail((String)("SearchManager not found but expected for cache " + cache.getName()));
        }
        if (!expected && searchManager != null) {
            Assert.fail((String)("SearchManager not expected but found for cache " + cache.getName()));
        }
        QueryInterceptor component = null;
        try {
            component = (QueryInterceptor)ComponentRegistryUtils.getComponent(cache, QueryInterceptor.class);
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        if (expected && component == null) {
            Assert.fail((String)("QueryInterceptor not found but expected for cache " + cache.getName()));
        }
        if (!expected && component != null) {
            Assert.fail((String)("QueryInterceptor not expected but found for cache " + cache.getName()));
        }
    }
}

