/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.queries.faceting;

import java.util.List;
import junit.framework.Assert;
import org.apache.lucene.search.Query;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.hibernate.search.query.facet.Facet;
import org.hibernate.search.query.facet.FacetingRequest;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.Search;
import org.infinispan.query.SearchManager;
import org.infinispan.query.queries.faceting.Car;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.faceting.SimpleFacetingTest")
public class SimpleFacetingTest
extends SingleCacheManagerTest {
    private static final String indexFieldName = "cubicCapacity";
    private static final String facetName = "ccs";
    private SearchManager qf;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder cfg = this.getDefaultStandaloneCacheConfig(true);
        cfg.indexing().enable().indexLocalOnly(false).addProperty("hibernate.search.default.directory_provider", "ram").addProperty("hibernate.search.lucene_version", "LUCENE_CURRENT");
        return TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)cfg);
    }

    @BeforeClass
    public void prepareSearchFactory() throws Exception {
        this.qf = Search.getSearchManager((Cache)this.cache);
        this.cache.put((Object)"195 Inter", (Object)new Car("Ferrari 195 Inter", "Rosso corsa", 2341));
        this.cache.put((Object)"212 Inter", (Object)new Car("Ferrari 212 Inter", "black", 4000));
        this.cache.put((Object)"500_Superfast", (Object)new Car("Ferrari 500_Superfast", "Rosso corsa", 4000));
        this.cache.put((Object)"500_Superfast", (Object)new Car("Ferrari 500_Superfast", "Rosso corsa", 4000));
    }

    @AfterMethod(alwaysRun=true)
    public void cleanupData() {
        this.cache.clear();
    }

    public void testFaceting() throws Exception {
        QueryBuilder queryBuilder = this.qf.buildQueryBuilderForClass(Car.class).get();
        FacetingRequest request = queryBuilder.facet().name(facetName).onField(indexFieldName).discrete().createFacetingRequest();
        Query luceneQuery = queryBuilder.all().createQuery();
        CacheQuery query = this.qf.getQuery(luceneQuery, new Class[0]);
        query.getFacetManager().enableFaceting(request);
        List facetList = query.getFacetManager().getFacets(facetName);
        Assert.assertEquals((String)"Wrong number of facets", (int)2, (int)facetList.size());
        Assert.assertEquals((String)"4000", (String)((Facet)facetList.get(0)).getValue());
        Assert.assertEquals((int)2, (int)((Facet)facetList.get(0)).getCount());
        Assert.assertEquals((String)indexFieldName, (String)((Facet)facetList.get(0)).getFieldName());
        Assert.assertEquals((String)"2341", (String)((Facet)facetList.get(1)).getValue());
        Assert.assertEquals((int)1, (int)((Facet)facetList.get(1)).getCount());
        Assert.assertEquals((String)indexFieldName, (String)((Facet)facetList.get(1)).getFieldName());
    }
}

