/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.backend;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.search.cfg.SearchMapping;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.cfg.spi.SearchConfigurationBase;
import org.hibernate.search.impl.SearchMappingBuilder;
import org.hibernate.search.spi.ServiceProvider;

public class SearchableCacheConfiguration
extends SearchConfigurationBase
implements SearchConfiguration {
    private final Map<String, Class<?>> classes;
    private final Properties properties;
    private final SearchMapping searchMapping;

    public SearchableCacheConfiguration(Class<?>[] classArray, Properties properties) {
        this.properties = properties == null ? new Properties() : properties;
        this.classes = new HashMap();
        for (Class<?> c : classArray) {
            String classname = c.getName();
            this.classes.put(classname, c);
        }
        this.searchMapping = SearchMappingBuilder.getSearchMapping((SearchConfiguration)this);
        if (this.searchMapping != null) {
            Set mappedEntities = this.searchMapping.getMappedEntities();
            for (Class entity : mappedEntities) {
                this.classes.put(entity.getName(), entity);
            }
        }
    }

    public Iterator<Class<?>> getClassMappings() {
        return this.classes.values().iterator();
    }

    public Class<?> getClassMapping(String name) {
        return this.classes.get(name);
    }

    public String getProperty(String propertyName) {
        return this.properties.getProperty(propertyName);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public ReflectionManager getReflectionManager() {
        return null;
    }

    public SearchMapping getProgrammaticMapping() {
        return this.searchMapping;
    }

    public Map<Class<? extends ServiceProvider<?>>, Object> getProvidedServices() {
        return Collections.emptyMap();
    }

    public boolean isTransactionManagerExpected() {
        return false;
    }

    public boolean isIdProvidedImplicit() {
        return true;
    }
}

