/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query;

import java.util.concurrent.ExecutorService;
import org.apache.lucene.search.Query;
import org.hibernate.search.SearchFactory;
import org.hibernate.search.query.dsl.EntityContext;
import org.hibernate.search.query.engine.spi.TimeoutExceptionFactory;
import org.hibernate.search.spi.SearchFactoryIntegrator;
import org.infinispan.AdvancedCache;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.SearchManager;
import org.infinispan.query.Transformer;
import org.infinispan.query.backend.QueryInterceptor;
import org.infinispan.query.clustered.ClusteredCacheQueryImpl;
import org.infinispan.query.impl.CacheQueryImpl;
import org.infinispan.query.impl.ComponentRegistryUtils;

class SearchManagerImpl
implements SearchManager {
    private final AdvancedCache<?, ?> cache;
    private final SearchFactoryIntegrator searchFactory;
    private final QueryInterceptor queryInterceptor;
    private TimeoutExceptionFactory timeoutExceptionFactory;

    SearchManagerImpl(AdvancedCache<?, ?> cache) {
        if (cache == null) {
            throw new IllegalArgumentException("cache parameter shall not be null");
        }
        this.cache = cache;
        this.searchFactory = ComponentRegistryUtils.getComponent(cache, SearchFactoryIntegrator.class);
        this.queryInterceptor = ComponentRegistryUtils.getQueryInterceptor(cache);
    }

    @Override
    public CacheQuery getQuery(Query luceneQuery, Class<?> ... classes) {
        this.queryInterceptor.enableClasses(classes);
        return new CacheQueryImpl(luceneQuery, this.searchFactory, this.cache, this.queryInterceptor.getKeyTransformationHandler(), this.timeoutExceptionFactory, classes);
    }

    @Override
    public CacheQuery getClusteredQuery(Query luceneQuery, Class<?> ... classes) {
        this.queryInterceptor.enableClasses(classes);
        ExecutorService asyncExecutor = this.queryInterceptor.getAsyncExecutor();
        return new ClusteredCacheQueryImpl(luceneQuery, this.searchFactory, asyncExecutor, this.cache, this.queryInterceptor.getKeyTransformationHandler(), classes);
    }

    @Override
    public void registerKeyTransformer(Class<?> keyClass, Class<? extends Transformer> transformerClass) {
        this.queryInterceptor.registerKeyTransformer(keyClass, transformerClass);
    }

    @Override
    public void setTimeoutExceptionFactory(TimeoutExceptionFactory timeoutExceptionFactory) {
        this.timeoutExceptionFactory = timeoutExceptionFactory;
    }

    @Override
    public EntityContext buildQueryBuilderForClass(Class<?> entityType) {
        this.queryInterceptor.enableClasses(new Class[]{entityType});
        return this.searchFactory.buildQueryBuilder().forEntity(entityType);
    }

    @Override
    public SearchFactory getSearchFactory() {
        return this.searchFactory;
    }
}

