/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.backend;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import org.hibernate.search.backend.TransactionContext;
import org.hibernate.search.backend.spi.Work;
import org.hibernate.search.backend.spi.WorkType;
import org.hibernate.search.engine.spi.EntityIndexBinder;
import org.hibernate.search.spi.SearchFactoryIntegrator;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.marshall.MarshalledValue;
import org.infinispan.query.Transformer;
import org.infinispan.query.backend.KeyTransformationHandler;
import org.infinispan.query.backend.TransactionalEventTransactionContext;
import org.infinispan.query.logging.Log;
import org.infinispan.util.concurrent.ConcurrentMapFactory;
import org.infinispan.util.logging.LogFactory;

public class QueryInterceptor
extends CommandInterceptor {
    private final SearchFactoryIntegrator searchFactory;
    private final ConcurrentMap<Class<?>, Boolean> knownClasses = ConcurrentMapFactory.makeConcurrentMap();
    private final Lock mutating = new ReentrantLock();
    private final KeyTransformationHandler keyTransformationHandler = new KeyTransformationHandler();
    protected TransactionManager transactionManager;
    protected TransactionSynchronizationRegistry transactionSynchronizationRegistry;
    protected ExecutorService asyncExecutor;
    private static final Log log = (Log)LogFactory.getLog(QueryInterceptor.class, Log.class);

    protected Log getLog() {
        return log;
    }

    public QueryInterceptor(SearchFactoryIntegrator searchFactory) {
        this.searchFactory = searchFactory;
    }

    @Inject
    public void injectDependencies(@ComponentName(value="org.infinispan.executors.transport") ExecutorService e) {
        this.asyncExecutor = e;
    }

    protected boolean shouldModifyIndexes(InvocationContext ctx) {
        return !ctx.hasFlag(Flag.SKIP_INDEXING);
    }

    public ExecutorService getAsyncExecutor() {
        return this.asyncExecutor;
    }

    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        Object toReturn = this.invokeNextInterceptor(ctx, (VisitableCommand)command);
        if (this.shouldModifyIndexes(ctx)) {
            this.getLog().debug("Infinispan Query indexing is triggered");
            Object key = command.getKey();
            Object value = this.extractValue(command.getValue());
            if (this.updateKnownTypesIfNeeded(value)) {
                this.updateIndexes(value, this.extractValue(key));
            } else if (this.updateKnownTypesIfNeeded(toReturn)) {
                this.removeFromIndexes(toReturn, this.extractValue(command.getKey()));
            }
        }
        return toReturn;
    }

    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        Object value;
        Object valueRemoved = this.invokeNextInterceptor(ctx, (VisitableCommand)command);
        if (command.isSuccessful() && !command.isNonExistent() && this.shouldModifyIndexes(ctx) && this.updateKnownTypesIfNeeded(value = this.extractValue(valueRemoved))) {
            this.removeFromIndexes(value, this.extractValue(command.getKey()));
        }
        return valueRemoved;
    }

    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        Object valueReplaced = this.invokeNextInterceptor(ctx, (VisitableCommand)command);
        if (valueReplaced != null && command.isSuccessful() && this.shouldModifyIndexes(ctx)) {
            Object[] parameters = command.getParameters();
            Object p1 = this.extractValue(parameters[1]);
            Object p2 = this.extractValue(parameters[2]);
            boolean originalIsIndexed = this.updateKnownTypesIfNeeded(p1);
            boolean newValueIsIndexed = this.updateKnownTypesIfNeeded(p2);
            Object key = this.extractValue(command.getKey());
            if (p1 != null && originalIsIndexed) {
                this.removeFromIndexes(p1, key);
            }
            if (newValueIsIndexed) {
                this.updateIndexes(p2, key);
            }
        }
        return valueReplaced;
    }

    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        Object mapPut = this.invokeNextInterceptor(ctx, (VisitableCommand)command);
        if (this.shouldModifyIndexes(ctx)) {
            Map dataMap = command.getMap();
            for (Map.Entry entry : dataMap.entrySet()) {
                Object value = this.extractValue(entry.getValue());
                if (!this.updateKnownTypesIfNeeded(value)) continue;
                this.updateIndexes(value, this.extractValue(entry.getKey()));
            }
        }
        return mapPut;
    }

    public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        Object returnValue = this.invokeNextInterceptor(ctx, (VisitableCommand)command);
        if (this.shouldModifyIndexes(ctx)) {
            if (this.getLog().isTraceEnabled()) {
                this.getLog().trace("shouldModifyIndexes() is true and we can clear the indexes");
            }
            for (Class c : this.knownClasses.keySet()) {
                EntityIndexBinder binder = this.searchFactory.getIndexBindingForEntity(c);
                if (binder == null) continue;
                this.searchFactory.getWorker().performWork(new Work(c, (Serializable)null, WorkType.PURGE_ALL), (TransactionContext)new TransactionalEventTransactionContext(this.transactionManager, this.transactionSynchronizationRegistry));
            }
        }
        return returnValue;
    }

    protected void removeFromIndexes(Object value, Object key) {
        if (value == null) {
            throw new NullPointerException("Cannot handle a null value!");
        }
        TransactionalEventTransactionContext transactionContext = new TransactionalEventTransactionContext(this.transactionManager, this.transactionSynchronizationRegistry);
        this.searchFactory.getWorker().performWork(new Work(value, (Serializable)((Object)this.keyToString(key)), WorkType.DELETE), (TransactionContext)transactionContext);
    }

    protected void updateIndexes(Object value, Object key) {
        if (value == null) {
            throw new NullPointerException("Cannot handle a null value!");
        }
        TransactionalEventTransactionContext transactionContext = new TransactionalEventTransactionContext(this.transactionManager, this.transactionSynchronizationRegistry);
        this.searchFactory.getWorker().performWork(new Work(value, (Serializable)((Object)this.keyToString(key)), WorkType.UPDATE), (TransactionContext)transactionContext);
    }

    private Object extractValue(Object wrappedValue) {
        if (wrappedValue instanceof MarshalledValue) {
            return ((MarshalledValue)wrappedValue).get();
        }
        return wrappedValue;
    }

    public void enableClasses(Class<?>[] classes) {
        if (classes == null || classes.length == 0) {
            return;
        }
        this.enableClassesIncrementally(classes, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void enableClassesIncrementally(Class<?>[] classes, boolean locked) {
        void var6_8;
        ArrayList toAdd = null;
        Class<?>[] arr$ = classes;
        int len$ = arr$.length;
        boolean bl = false;
        while (var6_8 < len$) {
            Class<?> type = arr$[var6_8];
            if (!this.knownClasses.containsKey(type)) {
                if (toAdd == null) {
                    toAdd = new ArrayList(classes.length);
                }
                toAdd.add(type);
            }
            ++var6_8;
        }
        if (toAdd == null) {
            return;
        }
        if (locked) {
            Class[] array = toAdd.toArray(new Class[toAdd.size()]);
            this.searchFactory.addClasses(array);
            for (Class clazz : toAdd) {
                if (this.searchFactory.getIndexBindingForEntity(clazz) != null) {
                    this.knownClasses.put(clazz, Boolean.TRUE);
                    continue;
                }
                this.knownClasses.put(clazz, Boolean.FALSE);
            }
        } else {
            this.mutating.lock();
            try {
                this.enableClassesIncrementally(classes, true);
            }
            finally {
                this.mutating.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateKnownTypesIfNeeded(Object value) {
        if (value != null) {
            Class<?> potentialNewType = value.getClass();
            if (!this.knownClasses.containsKey(potentialNewType)) {
                this.mutating.lock();
                try {
                    this.enableClassesIncrementally(new Class[]{potentialNewType}, true);
                }
                finally {
                    this.mutating.unlock();
                }
            }
            return (Boolean)this.knownClasses.get(potentialNewType);
        }
        return false;
    }

    public void registerKeyTransformer(Class<?> keyClass, Class<? extends Transformer> transformerClass) {
        this.keyTransformationHandler.registerTransformer(keyClass, transformerClass);
    }

    private String keyToString(Object key) {
        return this.keyTransformationHandler.keyToString(key);
    }

    public KeyTransformationHandler getKeyTransformationHandler() {
        return this.keyTransformationHandler;
    }

    public void enableClasses(Set<Class> knownIndexedTypes) {
        Class[] classes = knownIndexedTypes.toArray(new Class[knownIndexedTypes.size()]);
        this.enableClasses(classes);
    }
}

