/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.backend;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.search.cfg.SearchMapping;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.cfg.spi.SearchConfigurationBase;
import org.hibernate.search.impl.SearchMappingBuilder;
import org.hibernate.search.infinispan.CacheManagerServiceProvider;
import org.hibernate.search.spi.ServiceProvider;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.backend.ComponentRegistryServiceProvider;

public class SearchableCacheConfiguration
extends SearchConfigurationBase
implements SearchConfiguration {
    private final Map<String, Class<?>> classes;
    private final Properties properties;
    private final SearchMapping searchMapping;
    private final Map<Class<? extends ServiceProvider<?>>, Object> providedServices;

    public SearchableCacheConfiguration(Class<?>[] classArray, Properties properties, EmbeddedCacheManager uninitializedCacheManager, ComponentRegistry cr) {
        this.providedServices = SearchableCacheConfiguration.initializeProvidedServices(uninitializedCacheManager, cr);
        this.properties = properties == null ? new Properties() : properties;
        this.classes = new HashMap();
        for (Class<?> c : classArray) {
            String classname = c.getName();
            this.classes.put(classname, c);
        }
        this.searchMapping = SearchMappingBuilder.getSearchMapping((SearchConfiguration)this);
        if (this.searchMapping != null) {
            Set mappedEntities = this.searchMapping.getMappedEntities();
            for (Class entity : mappedEntities) {
                this.classes.put(entity.getName(), entity);
            }
        }
    }

    private static Map<Class<? extends ServiceProvider<?>>, Object> initializeProvidedServices(EmbeddedCacheManager uninitializedCacheManager, ComponentRegistry cr) {
        HashMap<Class, Object> map = new HashMap<Class, Object>(2);
        map.put(CacheManagerServiceProvider.class, uninitializedCacheManager);
        map.put(ComponentRegistryServiceProvider.class, cr);
        return Collections.unmodifiableMap(map);
    }

    public Iterator<Class<?>> getClassMappings() {
        return this.classes.values().iterator();
    }

    public Class<?> getClassMapping(String name) {
        return this.classes.get(name);
    }

    public String getProperty(String propertyName) {
        return this.properties.getProperty(propertyName);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public ReflectionManager getReflectionManager() {
        return null;
    }

    public SearchMapping getProgrammaticMapping() {
        return this.searchMapping;
    }

    public Map<Class<? extends ServiceProvider<?>>, Object> getProvidedServices() {
        return this.providedServices;
    }

    public boolean isTransactionManagerExpected() {
        return false;
    }

    public boolean isIdProvidedImplicit() {
        return true;
    }
}

