/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.indexmanager;

import java.util.List;
import java.util.Set;
import org.hibernate.search.SearchException;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.indexes.spi.IndexManager;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.remote.BaseRpcCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.query.CommandInitializer;
import org.infinispan.query.CustomQueryCommand;
import org.infinispan.query.backend.QueryInterceptor;

public class IndexUpdateCommand
extends BaseRpcCommand
implements ReplicableCommand,
CustomQueryCommand {
    public static final byte COMMAND_ID = 102;
    private SearchFactoryImplementor searchFactory;
    private byte[] serializedModel;
    private String indexName;
    private QueryInterceptor queryInterceptor;
    private Set<Class> knownIndexedTypes;

    public IndexUpdateCommand(String cacheName) {
        super(cacheName);
    }

    public Object perform(InvocationContext ctx) throws Throwable {
        this.queryInterceptor.enableClasses(this.knownIndexedTypes);
        IndexManager indexManager = this.searchFactory.getAllIndexesManager().getIndexManager(this.indexName);
        if (indexManager == null) {
            throw new SearchException("Unknown index referenced");
        }
        List luceneWorks = indexManager.getSerializer().toLuceneWorks(this.serializedModel);
        indexManager.performOperations(luceneWorks, null);
        return Boolean.TRUE;
    }

    public byte getCommandId() {
        return 102;
    }

    public Object[] getParameters() {
        return new Object[]{this.indexName, this.serializedModel, this.knownIndexedTypes};
    }

    public void setParameters(int commandId, Object[] parameters) {
        this.indexName = (String)parameters[0];
        this.serializedModel = (byte[])parameters[1];
        this.knownIndexedTypes = (Set)parameters[2];
    }

    public boolean isReturnValueExpected() {
        return false;
    }

    @Override
    public void fetchExecutionContext(CommandInitializer ci) {
        this.searchFactory = ci.getSearchFactory();
        this.queryInterceptor = ci.getQueryInterceptor();
    }

    public void setSerializedWorkList(byte[] serializedModel) {
        this.serializedModel = serializedModel;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public void setKnownIndexedTypes(Set<Class> knownIndexedTypes) {
        this.knownIndexedTypes = knownIndexedTypes;
    }
}

