/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl;

import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.hibernate.search.cfg.spi.SearchConfiguration;
import org.hibernate.search.spi.SearchFactoryBuilder;
import org.hibernate.search.spi.SearchFactoryIntegrator;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.InterceptorConfigurationBuilder;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.interceptors.InterceptorChain;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.interceptors.locking.NonTransactionalLockingInterceptor;
import org.infinispan.interceptors.locking.OptimisticLockingInterceptor;
import org.infinispan.interceptors.locking.PessimisticLockingInterceptor;
import org.infinispan.lifecycle.AbstractModuleLifecycle;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.CommandInitializer;
import org.infinispan.query.backend.LocalQueryInterceptor;
import org.infinispan.query.backend.QueryInterceptor;
import org.infinispan.query.backend.SearchableCacheConfiguration;
import org.infinispan.query.clustered.QueryBox;
import org.infinispan.query.logging.Log;
import org.infinispan.transaction.LockingMode;
import org.infinispan.util.logging.LogFactory;

public class LifecycleManager
extends AbstractModuleLifecycle {
    private static final Log log = (Log)LogFactory.getLog(LifecycleManager.class, Log.class);
    private final Map<String, SearchFactoryIntegrator> searchFactoriesToShutdown = new TreeMap<String, SearchFactoryIntegrator>();
    private static final Object REMOVED_REGISTRY_COMPONENT = new Object();

    public void cacheStarting(ComponentRegistry cr, Configuration cfg, String cacheName) {
        if (cfg.indexing().enabled()) {
            log.registeringQueryInterceptor();
            SearchFactoryIntegrator searchFactory = this.getSearchFactory((Properties)cfg.indexing().properties(), cr);
            this.createQueryInterceptorIfNeeded(cr, cfg, searchFactory);
        }
    }

    private void createQueryInterceptorIfNeeded(ComponentRegistry cr, Configuration cfg, SearchFactoryIntegrator searchFactory) {
        QueryInterceptor queryInterceptor = (QueryInterceptor)((Object)cr.getComponent(QueryInterceptor.class));
        if (queryInterceptor == null) {
            queryInterceptor = this.buildQueryInterceptor(cfg, searchFactory);
            InterceptorChain ic = (InterceptorChain)cr.getComponent(InterceptorChain.class);
            ConfigurationBuilder builder = new ConfigurationBuilder();
            InterceptorConfigurationBuilder interceptorBuilder = builder.customInterceptors().addInterceptor();
            interceptorBuilder.interceptor((CommandInterceptor)queryInterceptor);
            if (!cfg.transaction().transactionMode().isTransactional()) {
                if (ic != null) {
                    ic.addInterceptorAfter((CommandInterceptor)queryInterceptor, NonTransactionalLockingInterceptor.class);
                }
                interceptorBuilder.after(NonTransactionalLockingInterceptor.class);
            } else if (cfg.transaction().lockingMode() == LockingMode.OPTIMISTIC) {
                if (ic != null) {
                    ic.addInterceptorAfter((CommandInterceptor)queryInterceptor, OptimisticLockingInterceptor.class);
                }
                interceptorBuilder.after(OptimisticLockingInterceptor.class);
            } else {
                if (ic != null) {
                    ic.addInterceptorAfter((CommandInterceptor)queryInterceptor, PessimisticLockingInterceptor.class);
                }
                interceptorBuilder.after(PessimisticLockingInterceptor.class);
            }
            if (ic != null) {
                cr.registerComponent((Object)queryInterceptor, QueryInterceptor.class);
                cr.registerComponent((Object)queryInterceptor, ((Object)((Object)queryInterceptor)).getClass().getName(), true);
            }
            cfg.customInterceptors().interceptors(builder.build().customInterceptors().interceptors());
        }
    }

    private QueryInterceptor buildQueryInterceptor(Configuration cfg, SearchFactoryIntegrator searchFactory) {
        if (cfg.indexing().indexLocalOnly()) {
            return new LocalQueryInterceptor(searchFactory);
        }
        return new QueryInterceptor(searchFactory);
    }

    public void cacheStarted(ComponentRegistry cr, String cacheName) {
        Configuration configuration = (Configuration)cr.getComponent(Configuration.class);
        boolean indexingEnabled = configuration.indexing().enabled();
        if (!indexingEnabled) {
            if (this.verifyChainContainsQueryInterceptor(cr)) {
                throw new IllegalStateException("It was NOT expected to find the Query interceptor registered in the InterceptorChain as indexing was disabled, but it was found");
            }
            return;
        }
        if (!this.verifyChainContainsQueryInterceptor(cr)) {
            throw new IllegalStateException("It was expected to find the Query interceptor registered in the InterceptorChain but it wasn't found");
        }
        Cache cache = (Cache)cr.getComponent(Cache.class);
        CommandInitializer initializer = (CommandInitializer)cr.getComponent(CommandInitializer.class);
        initializer.setCache(cache);
        QueryBox queryBox = new QueryBox();
        queryBox.setCache(cache.getAdvancedCache());
        cr.registerComponent((Object)queryBox, QueryBox.class);
    }

    private boolean verifyChainContainsQueryInterceptor(ComponentRegistry cr) {
        InterceptorChain interceptorChain = (InterceptorChain)cr.getComponent(InterceptorChain.class);
        CommandInterceptor chainElement = interceptorChain.getFirstInChain();
        if (chainElement instanceof QueryInterceptor) {
            return true;
        }
        while (chainElement.hasNext()) {
            if (!((chainElement = chainElement.getNext()) instanceof QueryInterceptor)) continue;
            return true;
        }
        return false;
    }

    private SearchFactoryIntegrator getSearchFactory(Properties indexingProperties, ComponentRegistry cr) {
        Object component = cr.getComponent(SearchFactoryIntegrator.class);
        SearchFactoryIntegrator searchFactory = null;
        if (component instanceof SearchFactoryIntegrator) {
            searchFactory = (SearchFactoryIntegrator)component;
        }
        if (searchFactory == null) {
            GlobalComponentRegistry globalComponentRegistry = cr.getGlobalComponentRegistry();
            EmbeddedCacheManager uninitializedCacheManager = (EmbeddedCacheManager)globalComponentRegistry.getComponent(EmbeddedCacheManager.class);
            SearchableCacheConfiguration config = new SearchableCacheConfiguration(new Class[0], indexingProperties, uninitializedCacheManager, cr);
            searchFactory = new SearchFactoryBuilder().configuration((SearchConfiguration)config).buildSearchFactory();
            cr.registerComponent((Object)searchFactory, SearchFactoryIntegrator.class);
        }
        return searchFactory;
    }

    public void cacheStopping(ComponentRegistry cr, String cacheName) {
        SearchFactoryIntegrator searchFactoryImplementor = (SearchFactoryIntegrator)cr.getComponent(SearchFactoryIntegrator.class);
        if (searchFactoryImplementor != null && searchFactoryImplementor != REMOVED_REGISTRY_COMPONENT) {
            this.searchFactoriesToShutdown.put(cacheName, searchFactoryImplementor);
            cr.registerComponent(REMOVED_REGISTRY_COMPONENT, SearchFactoryIntegrator.class);
        }
    }

    public void cacheStopped(ComponentRegistry cr, String cacheName) {
        SearchFactoryIntegrator searchFactoryIntegrator = this.searchFactoriesToShutdown.remove(cacheName);
        if (searchFactoryIntegrator != null) {
            searchFactoryIntegrator.close();
        }
    }
}

