/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.nulls;

import java.util.List;
import java.util.concurrent.Callable;
import javax.transaction.TransactionManager;
import org.apache.lucene.search.Query;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.Search;
import org.infinispan.query.SearchManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.nulls.NullCollectionElementsTest")
public class NullCollectionElementsTest
extends SingleCacheManagerTest {
    private SearchManager searchManager;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder cfg = this.getDefaultStandaloneCacheConfig(true);
        cfg.indexing().enable().indexLocalOnly(true).addProperty("hibernate.search.default.directory_provider", "ram").addProperty("hibernate.search.lucene_version", "LUCENE_CURRENT");
        return TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)cfg);
    }

    protected void setup() throws Exception {
        super.setup();
        this.searchManager = Search.getSearchManager((Cache)this.cache);
    }

    @Test
    public void searchDoesNotReturnNullInCollection() throws Exception {
        TestingUtil.withTx((TransactionManager)this.tm(), (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                NullCollectionElementsTest.this.cache.put((Object)"1", (Object)new Foo("1"));
                return null;
            }
        });
        TestingUtil.withTx((TransactionManager)this.tm(), (Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                NullCollectionElementsTest.this.cache.remove((Object)"1");
                Query query = NullCollectionElementsTest.this.createQueryBuilder().keyword().onField("bar").matching((Object)"1").createQuery();
                List list = NullCollectionElementsTest.this.searchManager.getQuery(query, new Class[0]).list();
                assert (list.size() == 0);
                return null;
            }
        });
    }

    private QueryBuilder createQueryBuilder() {
        return this.searchManager.buildQueryBuilderForClass(Foo.class).get();
    }

    @Indexed(index="FooIndex")
    public class Foo {
        private String bar;

        public Foo(String bar) {
            this.bar = bar;
        }

        @Field(name="bar")
        public String getBar() {
            return this.bar;
        }
    }
}

