/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.backend;

import java.util.UUID;
import org.infinispan.query.backend.KeyTransformationHandler;
import org.infinispan.query.test.CustomKey;
import org.infinispan.query.test.CustomKey2;
import org.infinispan.query.test.CustomKey3;
import org.infinispan.query.test.CustomKey3Transformer;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.backend.KeyTransformationHandlerTest")
public class KeyTransformationHandlerTest {
    String s = null;
    Object key = null;
    private KeyTransformationHandler keyTransformationHandler;
    private static final UUID randomUUID = UUID.randomUUID();

    @BeforeMethod
    public void beforeMethod() {
        this.keyTransformationHandler = new KeyTransformationHandler();
    }

    public void testKeyToStringWithStringAndPrimitives() {
        this.s = this.keyTransformationHandler.keyToString((Object)"key");
        assert (this.s.equals("S:key"));
        this.s = this.keyTransformationHandler.keyToString((Object)1);
        assert (this.s.equals("I:1"));
        this.s = this.keyTransformationHandler.keyToString((Object)true);
        assert (this.s.equals("B:true"));
        this.s = this.keyTransformationHandler.keyToString((Object)1);
        assert (this.s.equals("X:1"));
        this.s = this.keyTransformationHandler.keyToString((Object)1L);
        assert (this.s.equals("L:1"));
        this.s = this.keyTransformationHandler.keyToString((Object)1);
        assert (this.s.equals("Y:1"));
        this.s = this.keyTransformationHandler.keyToString((Object)Float.valueOf(1.0f));
        assert (this.s.equals("F:1.0"));
        this.s = this.keyTransformationHandler.keyToString((Object)Character.valueOf('A'));
        assert (this.s.equals("C:A"));
        this.s = this.keyTransformationHandler.keyToString((Object)1.0);
        assert (this.s.equals("D:1.0"));
        this.s = this.keyTransformationHandler.keyToString((Object)randomUUID);
        assert (this.s.equals("U:" + randomUUID));
    }

    public void testStringToKeyWithStringAndPrimitives() {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        this.key = this.keyTransformationHandler.stringToKey("S:key1", contextClassLoader);
        assert (this.key.getClass().equals(String.class));
        assert (this.key.equals("key1"));
        this.key = this.keyTransformationHandler.stringToKey("I:2", contextClassLoader);
        assert (this.key.getClass().equals(Integer.class));
        assert (this.key.equals(2));
        this.key = this.keyTransformationHandler.stringToKey("Y:3", contextClassLoader);
        assert (this.key.getClass().equals(Byte.class));
        assert (this.key.equals((byte)3));
        this.key = this.keyTransformationHandler.stringToKey("F:4.0", contextClassLoader);
        assert (this.key.getClass().equals(Float.class));
        assert (this.key.equals(Float.valueOf(4.0f)));
        this.key = this.keyTransformationHandler.stringToKey("L:5", contextClassLoader);
        assert (this.key.getClass().equals(Long.class));
        assert (this.key.equals(5L));
        this.key = this.keyTransformationHandler.stringToKey("X:6", contextClassLoader);
        assert (this.key.getClass().equals(Short.class));
        assert (this.key.equals((short)6));
        this.key = this.keyTransformationHandler.stringToKey("B:true", contextClassLoader);
        assert (this.key.getClass().equals(Boolean.class));
        assert (this.key.equals(true));
        this.key = this.keyTransformationHandler.stringToKey("D:8.0", contextClassLoader);
        assert (this.key.getClass().equals(Double.class));
        assert (this.key.equals(8.0));
        this.key = this.keyTransformationHandler.stringToKey("C:9", contextClassLoader);
        assert (this.key.getClass().equals(Character.class));
        assert (this.key.equals(Character.valueOf('9')));
        this.key = this.keyTransformationHandler.stringToKey("U:" + randomUUID.toString(), contextClassLoader);
        assert (this.key.getClass().equals(UUID.class));
        assert (this.key.equals(randomUUID));
    }

    public void testStringToKeyWithCustomTransformable() {
        CustomKey customKey = new CustomKey(88, 8800, 12889976);
        String strRep = this.keyTransformationHandler.keyToString((Object)customKey);
        assert (customKey.equals(this.keyTransformationHandler.stringToKey(strRep, Thread.currentThread().getContextClassLoader())));
    }

    public void testStringToKeyWithDefaultTransformer() {
        CustomKey2 ck2 = new CustomKey2(Integer.MAX_VALUE, Integer.MIN_VALUE, 0);
        String strRep = this.keyTransformationHandler.keyToString((Object)ck2);
        assert (ck2.equals(this.keyTransformationHandler.stringToKey(strRep, Thread.currentThread().getContextClassLoader())));
    }

    public void testStringToKeyWithRegisteredTransformer() {
        this.keyTransformationHandler.registerTransformer(CustomKey3.class, CustomKey3Transformer.class);
        CustomKey3 key = new CustomKey3("str");
        String string = this.keyTransformationHandler.keyToString((Object)key);
        assert (key.equals(this.keyTransformationHandler.stringToKey(string, Thread.currentThread().getContextClassLoader())));
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testStringToKeyWithNoAvailableTransformer() {
        CustomKey3 key = new CustomKey3("str");
        String string = this.keyTransformationHandler.keyToString((Object)key);
        key.equals(this.keyTransformationHandler.stringToKey(string, Thread.currentThread().getContextClassLoader()));
    }
}

