/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.projection;

import java.util.Arrays;
import java.util.List;
import org.apache.lucene.search.Query;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.FetchOptions;
import org.infinispan.query.ResultIterator;
import org.infinispan.query.Search;
import org.infinispan.query.SearchManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.junit.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.projection.ProjectionTest")
public class ProjectionTest
extends SingleCacheManagerTest {
    private SearchManager searchManager;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder cfg = this.getDefaultStandaloneCacheConfig(true);
        cfg.indexing().enable().addProperty("default.directory_provider", "ram").addProperty("lucene_version", "LUCENE_CURRENT");
        EmbeddedCacheManager cacheManager = TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)cfg);
        Cache cache = cacheManager.getCache();
        this.searchManager = Search.getSearchManager((Cache)cache);
        return cacheManager;
    }

    @Test
    public void testQueryProjectionWithSingleField() throws Exception {
        this.cache.put((Object)"1", (Object)new Foo("bar1", "baz1"));
        CacheQuery cacheQuery = this.createProjectionQuery("bar");
        this.assertQueryReturns(cacheQuery, new Object[]{"bar1"});
    }

    @Test
    public void testQueryProjectionWithMultipleFields() throws Exception {
        this.cache.put((Object)"1", (Object)new Foo("bar1", "baz1"));
        CacheQuery cacheQuery = this.createProjectionQuery("bar", "baz");
        this.assertQueryReturns(cacheQuery, new Object[]{"bar1", "baz1"});
    }

    @Test
    public void testKeyProjectionConstant() throws Exception {
        this.cache.put((Object)"1", (Object)new Foo("bar1", "baz1"));
        CacheQuery cacheQuery = this.createProjectionQuery("__ISPN_Key");
        this.assertQueryReturns(cacheQuery, new Object[]{"1"});
    }

    @Test
    public void testValueProjectionConstant() throws Exception {
        Foo foo = new Foo("bar1", "baz1");
        this.cache.put((Object)"1", (Object)foo);
        CacheQuery cacheQuery = this.createProjectionQuery("__HSearch_This");
        this.assertQueryReturns(cacheQuery, new Object[]{foo});
    }

    @Test
    public void testMixedProjections() throws Exception {
        Foo foo = new Foo("bar1", "baz4");
        this.cache.put((Object)"1", (Object)foo);
        CacheQuery cacheQuery = this.createProjectionQuery("__ISPN_Key", "__HSearch_This", "__HSearch_This", "_hibernate_class", "baz", "bar");
        this.assertQueryReturns(cacheQuery, new Object[]{"1", foo, foo, foo.getClass(), foo.baz, foo.bar});
    }

    private CacheQuery createProjectionQuery(String ... projection) {
        QueryBuilder queryBuilder = this.searchManager.buildQueryBuilderForClass(Foo.class).get();
        Query query = queryBuilder.keyword().onField("bar").matching((Object)"bar1").createQuery();
        CacheQuery cacheQuery = this.searchManager.getQuery(query, new Class[0]);
        cacheQuery.projection(projection);
        return cacheQuery;
    }

    private void assertQueryReturns(CacheQuery cacheQuery, Object[] expected) {
        this.assertQueryListContains(cacheQuery.list(), expected);
        this.assertQueryIteratorContains(cacheQuery.iterator(new FetchOptions().fetchMode(FetchOptions.FetchMode.EAGER)), expected);
        this.assertQueryIteratorContains(cacheQuery.iterator(new FetchOptions().fetchMode(FetchOptions.FetchMode.LAZY)), expected);
    }

    private void assertQueryListContains(List list, Object[] expected) {
        assert (list.size() == 1);
        Object[] array = (Object[])list.get(0);
        Assert.assertArrayEquals((Object[])expected, (Object[])array);
    }

    private void assertQueryIteratorContains(ResultIterator iterator, Object[] expected) {
        assert (iterator.hasNext());
        Object[] array = (Object[])iterator.next();
        assert (Arrays.equals(array, expected));
        assert (!iterator.hasNext());
    }

    @Indexed(index="FooIndex")
    public static class Foo {
        private String bar;
        private String baz;

        public Foo(String bar, String baz) {
            this.bar = bar;
            this.baz = baz;
        }

        @Field(name="bar", store=Store.YES)
        public String getBar() {
            return this.bar;
        }

        @Field(name="baz", store=Store.YES)
        public String getBaz() {
            return this.baz;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Foo foo = (Foo)o;
            if (this.bar != null ? !this.bar.equals(foo.bar) : foo.bar != null) {
                return false;
            }
            return !(this.baz != null ? !this.baz.equals(foo.baz) : foo.baz != null);
        }

        public int hashCode() {
            return this.bar.hashCode();
        }
    }
}

