/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.statetransfer;

import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.CacheLoaderManager;
import org.infinispan.loaders.CacheStore;
import org.infinispan.loaders.dummy.DummyInMemoryCacheStore;
import org.infinispan.query.statetransfer.BaseReIndexingTest;
import org.infinispan.query.test.Person;
import org.infinispan.test.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.statetransfer.PersistentStateTransferQueryIndexTest")
public class PersistentStateTransferQueryIndexTest
extends BaseReIndexingTest {
    @Override
    protected void configureCache(ConfigurationBuilder builder) {
        builder.clustering().stateTransfer().fetchInMemoryState(false).loaders().passivation(true).shared(false).addStore().cacheStore((CacheStore)new DummyInMemoryCacheStore()).fetchPersistentState(true);
    }

    public void testFetchingPersistentStateUpdatesIndex() throws Exception {
        this.loadCacheEntries((Cache<String, Person>)((Cache)this.caches().get(0)));
        Cache cache1 = (Cache)this.caches().get(0);
        this.executeSimpleQuery((Cache<String, Person>)cache1);
        this.checkCacheStoresEmpty();
        for (Cache cache : this.caches()) {
            for (Person p2 : this.persons) {
                cache.evict((Object)p2.getName());
            }
        }
        this.checkCacheStoresContainPersons();
        this.addNodeCheckingContentsAndQuery();
    }

    private void checkCacheStoresContainPersons() throws CacheLoaderException {
        for (Cache cache : this.caches()) {
            CacheStore store = ((CacheLoaderManager)TestingUtil.extractComponent((Cache)cache, CacheLoaderManager.class)).getCacheStore();
            for (int i = 0; i < this.persons.length; ++i) {
                AssertJUnit.assertEquals((Object)this.persons[i], (Object)store.load((Object)this.persons[i].getName()).getValue());
            }
        }
    }

    private void checkCacheStoresEmpty() throws CacheLoaderException {
        for (Cache cache : this.caches()) {
            CacheStore store = ((CacheLoaderManager)TestingUtil.extractComponent((Cache)cache, CacheLoaderManager.class)).getCacheStore();
            for (Person person : this.persons) {
                assert (!store.containsKey((Object)person.getName()));
            }
        }
    }
}

