/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.programmaticmapping;

import java.lang.annotation.ElementType;
import java.util.Properties;
import org.apache.lucene.search.Query;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.cfg.SearchMapping;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.Search;
import org.infinispan.query.SearchManager;
import org.infinispan.test.CacheManagerCallable;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.programmaticmapping.SearchMappingTest")
public class SearchMappingTest {
    @Test
    public void testSearchMapping() {
        SearchMapping mapping = new SearchMapping();
        mapping.entity(BondPVO.class).indexed().property("id", ElementType.METHOD).field().property("name", ElementType.METHOD).field().property("isin", ElementType.METHOD).field();
        Properties properties = new Properties();
        properties.put("default.directory_provider", "ram");
        properties.put("hibernate.search.model_mapping", mapping);
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.indexing().enable().indexLocalOnly(true).withProperties(properties);
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)builder)){

            public void call() {
                Cache cache = this.cm.getCache();
                SearchManager sm = Search.getSearchManager((Cache)cache);
                BondPVO bond = new BondPVO(1L, "Test", "DE000123");
                cache.put((Object)bond.getId(), (Object)bond);
                QueryBuilder qb = sm.buildQueryBuilderForClass(BondPVO.class).get();
                Query q = qb.keyword().onField("name").matching((Object)"Test").createQuery();
                CacheQuery cq = sm.getQuery(q, new Class[]{BondPVO.class});
                Assert.assertEquals((int)cq.getResultSize(), (int)1);
            }
        });
    }

    @Test
    public void testWithoutSearchMapping() {
        Properties properties = new Properties();
        properties.put("default.directory_provider", "ram");
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.indexing().enable().indexLocalOnly(true).withProperties(properties);
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)builder)){

            public void call() {
                Cache cache = this.cm.getCache();
                SearchManager sm = Search.getSearchManager((Cache)cache);
                BondPVO2 bond = new BondPVO2(1L, "Test", "DE000123");
                cache.put((Object)bond.getId(), (Object)bond);
                QueryBuilder qb = sm.buildQueryBuilderForClass(BondPVO2.class).get();
                Query q = qb.keyword().onField("name").matching((Object)"Test").createQuery();
                CacheQuery cq = sm.getQuery(q, new Class[]{BondPVO2.class});
                Assert.assertEquals((int)cq.getResultSize(), (int)1);
            }
        });
    }

    @Indexed
    public static final class BondPVO2 {
        @Field
        private long id;
        @Field
        private String name;
        @Field
        private String isin;

        public BondPVO2(long id, String name, String isin) {
            this.id = id;
            this.name = name;
            this.isin = isin;
        }

        public long getId() {
            return this.id;
        }

        public void setId(long id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getIsin() {
            return this.isin;
        }

        public void setIsin(String isin) {
            this.isin = isin;
        }
    }

    public static final class BondPVO {
        private long id;
        private String name;
        private String isin;

        public BondPVO(long id, String name, String isin) {
            this.id = id;
            this.name = name;
            this.isin = isin;
        }

        public long getId() {
            return this.id;
        }

        public void setId(long id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getIsin() {
            return this.isin;
        }

        public void setIsin(String isin) {
            this.isin = isin;
        }
    }
}

