/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.config;

import java.io.IOException;
import org.infinispan.Cache;
import org.infinispan.query.Search;
import org.infinispan.query.SearchManager;
import org.infinispan.query.backend.LocalQueryInterceptor;
import org.infinispan.query.backend.QueryInterceptor;
import org.infinispan.query.impl.ComponentRegistryUtils;
import org.infinispan.test.CacheManagerCallable;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="query.config.QueryParsingTest")
public class DefaultCacheInheritancePreventedTest {
    @Test
    public void verifyIndexDisabledCorrectly() throws IOException {
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(TestCacheManagerFactory.fromXml((String)"configuration-parsing-test-enbledInDefault.xml")){

            public void call() {
                DefaultCacheInheritancePreventedTest.this.assertIndexingEnabled((Cache<Object, Object>)this.cm.getCache(), true, QueryInterceptor.class);
                DefaultCacheInheritancePreventedTest.this.assertIndexingEnabled((Cache<Object, Object>)this.cm.getCache("simple"), true, QueryInterceptor.class);
                DefaultCacheInheritancePreventedTest.this.assertIndexingEnabled((Cache<Object, Object>)this.cm.getCache("not-searchable"), false, QueryInterceptor.class);
                DefaultCacheInheritancePreventedTest.this.assertIndexingEnabled((Cache<Object, Object>)this.cm.getCache("memory-searchable"), true, QueryInterceptor.class);
                DefaultCacheInheritancePreventedTest.this.assertIndexingEnabled((Cache<Object, Object>)this.cm.getCache("disk-searchable"), true, LocalQueryInterceptor.class);
            }
        });
    }

    @Test
    public void verifyIndexEnabledCorrectly() throws IOException {
        TestingUtil.withCacheManager((CacheManagerCallable)new CacheManagerCallable(TestCacheManagerFactory.fromXml((String)"configuration-parsing-test.xml")){

            public void call() {
                DefaultCacheInheritancePreventedTest.this.assertIndexingEnabled((Cache<Object, Object>)this.cm.getCache(), false, QueryInterceptor.class);
                DefaultCacheInheritancePreventedTest.this.assertIndexingEnabled((Cache<Object, Object>)this.cm.getCache("simple"), false, QueryInterceptor.class);
                DefaultCacheInheritancePreventedTest.this.assertIndexingEnabled((Cache<Object, Object>)this.cm.getCache("memory-searchable"), true, QueryInterceptor.class);
                DefaultCacheInheritancePreventedTest.this.assertIndexingEnabled((Cache<Object, Object>)this.cm.getCache("disk-searchable"), true, LocalQueryInterceptor.class);
            }
        });
    }

    private void assertIndexingEnabled(Cache<Object, Object> cache, boolean expected, Class<? extends QueryInterceptor> expectedQueryInterceptorType) {
        SearchManager searchManager = null;
        try {
            searchManager = Search.getSearchManager(cache);
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        if (expected && searchManager == null) {
            Assert.fail((String)("SearchManager not found but expected for cache " + cache.getName()));
        }
        if (!expected && searchManager != null) {
            Assert.fail((String)("SearchManager not expected but found for cache " + cache.getName()));
        }
        QueryInterceptor component = null;
        try {
            component = (QueryInterceptor)ComponentRegistryUtils.getComponent(cache, expectedQueryInterceptorType);
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        if (expected && component == null) {
            Assert.fail((String)("QueryInterceptor not found but expected for cache " + cache.getName()));
        }
        if (!expected && component != null) {
            Assert.fail((String)("QueryInterceptor not expected but found for cache " + cache.getName()));
        }
    }
}

