/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.distributed;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.transaction.TransactionManager;
import junit.framework.Assert;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.infinispan.Cache;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.Search;
import org.infinispan.query.SearchManager;
import org.infinispan.query.indexmanager.InfinispanCommandsBackend;
import org.infinispan.query.indexmanager.InfinispanIndexManager;
import org.infinispan.query.test.Person;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.distributed.MultiNodeDistributedTest")
public class MultiNodeDistributedTest
extends AbstractInfinispanTest {
    private List<EmbeddedCacheManager> cacheManagers = new ArrayList<EmbeddedCacheManager>(4);
    private List<Cache<String, Person>> caches = new ArrayList<Cache<String, Person>>(4);

    protected EmbeddedCacheManager createCacheManager() throws IOException {
        EmbeddedCacheManager cacheManager = TestCacheManagerFactory.fromXml((String)this.getConfigurationResourceName());
        this.cacheManagers.add(cacheManager);
        Cache cache = cacheManager.getCache();
        this.caches.add((Cache<String, Person>)cache);
        TestingUtil.waitForRehashToComplete(this.caches);
        return cacheManager;
    }

    protected String getConfigurationResourceName() {
        return "dynamic-indexing-distribution.xml";
    }

    private void storeOn(Cache<String, Person> cache, String key, Person person) throws Exception {
        TransactionManager transactionManager = cache.getAdvancedCache().getTransactionManager();
        if (this.transactionsEnabled()) {
            transactionManager.begin();
        }
        cache.put((Object)key, (Object)person);
        if (this.transactionsEnabled()) {
            transactionManager.commit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIndexingWorkDistribution() throws Exception {
        try {
            this.createCacheManager();
            this.createCacheManager();
            this.assertIndexSize(0);
            this.storeOn(this.caches.get(0), "k1", new Person("K. Firt", "Is not a character from the matrix", 1));
            this.assertIndexSize(1);
            this.storeOn(this.caches.get(1), "k2", new Person("K. Seycond", "Is a pilot", 1));
            this.assertIndexSize(2);
            this.storeOn(this.caches.get(0), "k3", new Person("K. Theerd", "Forgot the fundamental laws", 1));
            this.assertIndexSize(3);
            this.storeOn(this.caches.get(1), "k3", new Person("K. Overide", "Impersonating Mr. Theerd", 1));
            this.assertIndexSize(3);
            this.createCacheManager();
            this.storeOn(this.caches.get(2), "k4", new Person("K. Forth", "Dynamic Topology!", 1));
            this.assertIndexSize(4);
            this.createCacheManager();
            this.assertIndexSize(4);
            this.killMasterNode();
            this.storeOn(this.caches.get(2), "k5", new Person("K. Vife", "Failover!", 1));
            this.assertIndexSize(5);
        }
        finally {
            TestingUtil.killCacheManagers(this.cacheManagers);
        }
    }

    private void killMasterNode() {
        for (Cache<String, Person> cache : this.caches) {
            if (!this.isMasterNode(cache)) continue;
            TestingUtil.killCacheManagers((EmbeddedCacheManager[])new EmbeddedCacheManager[]{cache.getCacheManager()});
            this.caches.remove(cache);
            this.cacheManagers.remove(cache.getCacheManager());
            TestingUtil.waitForRehashToComplete(this.caches);
            break;
        }
    }

    private boolean isMasterNode(Cache cache) {
        SearchManager searchManager = Search.getSearchManager((Cache)cache);
        SearchFactoryImplementor searchFactory = (SearchFactoryImplementor)searchManager.getSearchFactory();
        InfinispanIndexManager indexManager = (InfinispanIndexManager)searchFactory.getAllIndexesManager().getIndexManager("person");
        InfinispanCommandsBackend commandsBackend = indexManager.getRemoteMaster();
        return commandsBackend.isMasterLocal();
    }

    private void assertIndexSize(int expectedIndexSize) {
        for (Cache<String, Person> cache : this.caches) {
            SearchManager searchManager = Search.getSearchManager(cache);
            CacheQuery query = searchManager.getQuery((Query)new MatchAllDocsQuery(), new Class[]{Person.class});
            Assert.assertEquals((int)expectedIndexSize, (int)query.list().size());
        }
    }

    private boolean transactionsEnabled() {
        return false;
    }
}

