/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.distributed;

import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import org.apache.lucene.search.Query;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.Search;
import org.infinispan.query.SearchManager;
import org.infinispan.query.distributed.NonSerializableKeyType;
import org.infinispan.query.queries.faceting.Car;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.distributed.DistributedMassIndexing")
public class DistributedMassIndexingTest
extends MultipleCacheManagersTest {
    protected static final int NUM_NODES = 4;
    protected List<Cache> caches = new ArrayList<Cache>(4);
    protected static final String[] neededCacheNames = new String[]{"___defaultcache", "LuceneIndexesMetadata", "LuceneIndexesData", "LuceneIndexesLocking"};

    protected void createCacheManagers() throws Throwable {
        EmbeddedCacheManager cacheManager = null;
        for (int i = 0; i < 4; ++i) {
            cacheManager = TestCacheManagerFactory.fromXml((String)"dynamic-indexing-distribution.xml");
            this.registerCacheManager(new CacheContainer[]{cacheManager});
            Cache cache = cacheManager.getCache();
            this.caches.add(cache);
        }
        this.waitForClusterToForm(neededCacheNames);
    }

    public void testReindexing() throws Exception {
        this.caches.get(0).put(this.key("F1NUM"), (Object)new Car("megane", "white", 300));
        this.verifyFindsCar(1, "megane");
        this.caches.get(1).put(this.key("F2NUM"), (Object)new Car("megane", "blue", 300));
        this.verifyFindsCar(2, "megane");
        this.caches.get(1).getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_INDEXING}).put(this.key("F3NUM"), (Object)new Car("megane", "blue", 300));
        this.verifyFindsCar(2, "megane");
        this.rebuildIndexes();
        this.verifyFindsCar(3, "megane");
        this.caches.get(3).getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_INDEXING}).remove(this.key("F2NUM"));
        this.verifyFindsCar(3, "megane");
        this.rebuildIndexes();
        this.verifyFindsCar(2, "megane");
    }

    private Object key(String keyId) {
        return new NonSerializableKeyType(keyId);
    }

    protected void rebuildIndexes() throws Exception {
        Cache cache = this.caches.get(0);
        SearchManager searchManager = Search.getSearchManager((Cache)cache);
        searchManager.getMassIndexer().start();
    }

    private void verifyFindsCar(int expectedCount, String carMake) {
        for (Cache cache : this.caches) {
            this.verifyFindsCar(cache, expectedCount, carMake);
        }
    }

    protected void verifyFindsCar(Cache cache, int expectedCount, String carMake) {
        SearchManager searchManager = Search.getSearchManager((Cache)cache);
        QueryBuilder carQueryBuilder = searchManager.buildQueryBuilderForClass(Car.class).get();
        Query fullTextQuery = carQueryBuilder.keyword().onField("make").matching((Object)carMake).createQuery();
        CacheQuery cacheQuery = searchManager.getQuery(fullTextQuery, new Class[]{Car.class});
        Assert.assertEquals((int)expectedCount, (int)cacheQuery.getResultSize());
    }
}

