/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.distributed;

import java.util.List;
import junit.framework.Assert;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Query;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.Search;
import org.infinispan.query.distributed.DistributedMassIndexingTest;
import org.infinispan.query.helper.TestQueryHelperFactory;
import org.infinispan.query.queries.faceting.Car;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.distributed.DistProgrammaticMassIndex")
public class DistProgrammaticMassIndexTest
extends DistributedMassIndexingTest {
    @Override
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder cacheCfg = DistProgrammaticMassIndexTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false);
        cacheCfg.indexing().enable().indexLocalOnly(true).addProperty("hibernate.search.default.indexmanager", "org.infinispan.query.indexmanager.InfinispanIndexManager").addProperty("hibernate.search.default.directory_provider", "infinispan").addProperty("hibernate.search.default.exclusive_index_use", "false").addProperty("lucene_version", "LUCENE_36");
        List cacheList = this.createClusteredCaches(4, cacheCfg);
        for (int i = 0; i < 4; ++i) {
            ConfigurationBuilder cacheCfg1 = DistProgrammaticMassIndexTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.REPL_SYNC, (boolean)false);
            ((EmbeddedCacheManager)this.cacheManagers.get(i)).defineConfiguration("LuceneIndexesData", cacheCfg1.build());
            ((EmbeddedCacheManager)this.cacheManagers.get(i)).defineConfiguration("LuceneIndexesLocking", cacheCfg1.build());
        }
        this.waitForClusterToForm(neededCacheNames);
        for (Cache cache : cacheList) {
            this.caches.add(cache);
        }
    }

    @Override
    protected void verifyFindsCar(Cache cache, int count, String carMake) {
        QueryParser queryParser = TestQueryHelperFactory.createQueryParser("make");
        try {
            Query luceneQuery = queryParser.parse(carMake);
            CacheQuery cacheQuery = Search.getSearchManager((Cache)cache).getQuery(luceneQuery, new Class[]{Car.class});
            Assert.assertEquals((int)count, (int)cacheQuery.getResultSize());
        }
        catch (ParseException ex) {
            ex.printStackTrace();
            Assert.fail((String)("Failed due to: " + ex.getMessage()));
        }
    }
}

