/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.distributed;

import java.io.IOException;
import java.util.List;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.distributed.MultiNodeDistributedTest;
import org.infinispan.query.test.Person;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.transaction.TransactionMode;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.distributed.MultiNodeLocalTest")
public class MultiNodeLocalTest
extends MultiNodeDistributedTest {
    @Override
    protected EmbeddedCacheManager createCacheManager() throws IOException {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.clustering().cacheMode(CacheMode.LOCAL).indexing().enabled(true).addProperty("hibernate.search.lucene_version", "LUCENE_CURRENT").addProperty("default.exclusive_index_use", "false").addProperty("default.indexmanager", "org.infinispan.query.indexmanager.InfinispanIndexManager");
        if (this.transactionsEnabled()) {
            builder.transaction().transactionMode(TransactionMode.TRANSACTIONAL);
        }
        EmbeddedCacheManager cacheManager = TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)builder);
        this.cacheManagers.add(cacheManager);
        Cache cache = cacheManager.getCache();
        this.caches.add(cache);
        return cacheManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void testIndexingWorkDistribution() throws Exception {
        try {
            this.createCacheManager();
            this.assertIndexSize(0);
            this.storeOn((Cache<String, Person>)((Cache)this.caches.get(0)), "k1", new Person("K. Firt", "Is not a character from the matrix", 1));
            this.assertIndexSize(1);
            this.createCacheManager();
            this.storeOn((Cache<String, Person>)((Cache)this.caches.get(1)), "k2", new Person("K. Seycond", "Is a pilot", 1));
            this.assertIndexSize(1);
            this.killMasterNode();
            this.assertIndexSize(1);
        }
        finally {
            TestingUtil.killCacheManagers((List)this.cacheManagers);
        }
    }
}

