/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.searchmanager;

import java.util.concurrent.TimeUnit;
import org.apache.lucene.search.Query;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.query.engine.spi.TimeoutExceptionFactory;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.Search;
import org.infinispan.query.SearchManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.TimeoutTest")
public class TimeoutTest
extends SingleCacheManagerTest {
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder cfg = this.getDefaultStandaloneCacheConfig(true);
        cfg.indexing().enable().indexLocalOnly(false).addProperty("default.directory_provider", "ram").addProperty("lucene_version", "LUCENE_CURRENT");
        return TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)cfg);
    }

    @Test
    public void timeoutExceptionIsThrownAndIsProducedByMyFactory() throws Exception {
        SearchManager searchManager = Search.getSearchManager((Cache)this.cache);
        searchManager.setTimeoutExceptionFactory((TimeoutExceptionFactory)new MyTimeoutExceptionFactory());
        Query query = searchManager.buildQueryBuilderForClass(Foo.class).get().keyword().onField("bar").matching((Object)"1").createQuery();
        CacheQuery cacheQuery = searchManager.getQuery(query, new Class[0]);
        cacheQuery.timeout(1L, TimeUnit.NANOSECONDS);
        try {
            cacheQuery.list();
            Assert.fail((String)"Expected MyTimeoutException");
        }
        catch (MyTimeoutException myTimeoutException) {
            // empty catch block
        }
    }

    @Indexed(index="FooIndex")
    public class Foo {
        private String bar;

        public Foo(String bar) {
            this.bar = bar;
        }

        @Field(name="bar")
        public String getBar() {
            return this.bar;
        }
    }

    public static class MyTimeoutException
    extends RuntimeException {
    }

    private static class MyTimeoutExceptionFactory
    implements TimeoutExceptionFactory {
        private MyTimeoutExceptionFactory() {
        }

        public RuntimeException createTimeoutException(String message, Query query) {
            return new MyTimeoutException();
        }
    }
}

