/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.cacheloaders;

import java.util.List;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.loaders.CacheStore;
import org.infinispan.loaders.dummy.DummyInMemoryCacheStore;
import org.infinispan.query.statetransfer.BaseReIndexingTest;
import org.infinispan.query.test.Person;
import org.infinispan.test.TestingUtil;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.cacheloaders.SharedCacheLoaderQueryIndexTest", enabled=false, description="Temporary disabled: https://issues.jboss.org/browse/ISPN-2249 , https://issues.jboss.org/browse/ISPN-1586")
public class SharedCacheLoaderQueryIndexTest
extends BaseReIndexingTest {
    @Override
    protected void configureCache(ConfigurationBuilder builder) {
        builder.clustering().stateTransfer().fetchInMemoryState(false).loaders().shared(true).preload(true).addStore().cacheStore((CacheStore)new DummyInMemoryCacheStore()).addProperty("storeName", ((Object)((Object)this)).getClass().getName());
    }

    public void testPreloadIndexingAfterAddingNewNode() throws Exception {
        this.loadCacheEntries((Cache<String, Person>)((Cache)this.caches().get(0)));
        for (CacheStore cs : TestingUtil.cachestores((List)this.caches())) {
            assert (cs.containsKey((Object)this.persons[0].getName())) : "Cache misconfigured, maybe cache store not pointing to same place, maybe passivation on...etc";
            DummyInMemoryCacheStore dimcs = (DummyInMemoryCacheStore)cs;
            assert ((Integer)dimcs.stats().get("clear") == 0) : "Cache store should not be cleared, purgeOnStartup is false";
            assert ((Integer)dimcs.stats().get("store") == 4) : "Cache store should have been written to 4 times, but was written to " + dimcs.stats().get("store") + " times";
        }
        this.executeSimpleQuery((Cache<String, Person>)((Cache)this.caches().get(0)));
        this.addNodeCheckingContentsAndQuery();
    }
}

