/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.jmx;

import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.infinispan.CacheException;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.jmx.PerThreadMBeanServerLookup;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.jmx.QueryMBeanTest")
public class QueryMBeanTest
extends SingleCacheManagerTest {
    static final String JMX_DOMAIN = QueryMBeanTest.class.getSimpleName();
    static final String CACHE_NAME = "queryable-cache";
    MBeanServer server;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        EmbeddedCacheManager cm = TestCacheManagerFactory.createCacheManagerEnforceJmxDomain((String)JMX_DOMAIN);
        ConfigurationBuilder builder = this.getDefaultStandaloneCacheConfig(true);
        builder.indexing().enable().indexLocalOnly(false).addProperty("default.directory_provider", "ram").addProperty("lucene_version", "LUCENE_CURRENT");
        cm.defineConfiguration(CACHE_NAME, builder.build());
        return cm;
    }

    protected void setup() throws Exception {
        super.setup();
        this.server = PerThreadMBeanServerLookup.getThreadMBeanServer();
    }

    public void testQueryStatsMBean() throws Exception {
        this.cacheManager.getCache(CACHE_NAME);
        ObjectName name = this.getQueryStatsObjectName(JMX_DOMAIN, CACHE_NAME);
        assert (this.server.isRegistered(name));
        assert (!((Boolean)this.server.getAttribute(name, "StatisticsEnabled")).booleanValue());
        this.server.setAttribute(name, new Attribute("StatisticsEnabled", true));
        assert (((Boolean)this.server.getAttribute(name, "StatisticsEnabled")).booleanValue());
    }

    ObjectName getQueryStatsObjectName(String jmxDomain, String cacheName) {
        try {
            return new ObjectName(jmxDomain + ":type=Query,name=" + ObjectName.quote(cacheName) + ",component=Statistics");
        }
        catch (MalformedObjectNameException e) {
            throw new CacheException("Malformed object name", (Throwable)e);
        }
    }
}

