/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.api;

import java.util.Iterator;
import java.util.Map;
import org.hibernate.search.backend.LuceneWork;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.distexec.mapreduce.Collector;
import org.infinispan.distexec.mapreduce.MapReduceTask;
import org.infinispan.distexec.mapreduce.Mapper;
import org.infinispan.distexec.mapreduce.Reducer;
import org.infinispan.query.impl.massindex.IndexingMapper;
import org.infinispan.query.impl.massindex.IndexingReducer;
import org.infinispan.query.queries.faceting.Car;
import org.infinispan.test.MultipleCacheManagersTest;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.api.MapReduceInitializerTest")
public class MapReduceInitializerTest
extends MultipleCacheManagersTest {
    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder cacheCfg = MapReduceInitializerTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)false);
        cacheCfg.indexing().enable().indexLocalOnly(true).addProperty("default.indexmanager", "org.infinispan.query.indexmanager.InfinispanIndexManager").addProperty("default.exclusive_index_use", "false").addProperty("lucene_version", "LUCENE_36");
        this.createClusteredCaches(2, cacheCfg);
    }

    public void testInitMapper() throws InterruptedException {
        this.cache(0).put((Object)"key1", (Object)new Car("ford", "blue", 160));
        this.cache(1).put((Object)"key2", (Object)new Car("bmw", "black", 160));
        this.cache(0).put((Object)"key3", (Object)new Car("mersedes", "white", 160));
        Map result = new MapReduceTask(this.cache(0)).mappedWith((Mapper)new SomeMapper()).reducedWith((Reducer)new IndexingReducer()).execute();
        Assert.assertTrue((boolean)result.isEmpty());
    }

    public void testInitReducer() throws InterruptedException {
        this.cache(0).put((Object)"key1", (Object)new Car("ford", "blue", 160));
        this.cache(1).put((Object)"key2", (Object)new Car("bmw", "black", 160));
        this.cache(0).put((Object)"key3", (Object)new Car("mersedes", "white", 160));
        Map result = new MapReduceTask(this.cache(0)).mappedWith((Mapper)new IndexingMapper()).reducedWith((Reducer)new SomeReducer()).execute();
        Assert.assertFalse((boolean)result.isEmpty());
    }

    private static class SomeMapper
    implements Mapper<Object, Object, Object, LuceneWork> {
        private SomeMapper() {
        }

        public void map(Object key, Object value, Collector<Object, LuceneWork> collector) {
            System.out.println("Some stuff to do.");
        }
    }

    private static class SomeReducer
    implements Reducer<Object, LuceneWork> {
        private SomeReducer() {
        }

        public LuceneWork reduce(Object reducedKey, Iterator<LuceneWork> iter) {
            return iter.next();
        }
    }
}

