/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.config;

import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.LegacyConfigurationAdaptor;
import org.infinispan.util.TypedProperties;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.config.LegacyConfigurationAdaptorTest")
public class LegacyConfigurationAdaptorTest {
    @Test
    public void testIndexingWithLegacyAdapt() {
        ConfigurationBuilder cacheCfg = new ConfigurationBuilder();
        cacheCfg.indexing().enable().indexLocalOnly(false).addProperty("default.directory_provider", "ram").addProperty("lucene_version", "LUCENE_CURRENT");
        org.infinispan.config.Configuration legacy = LegacyConfigurationAdaptor.adapt((Configuration)cacheCfg.build());
        assert (legacy.isIndexingEnabled());
        assert (!legacy.isIndexLocalOnly());
        TypedProperties p = legacy.getIndexingProperties();
        AssertJUnit.assertEquals((String)"ram", (String)p.getProperty("default.directory_provider"));
        AssertJUnit.assertEquals((String)"LUCENE_CURRENT", (String)p.getProperty("lucene_version"));
    }

    @Test
    public void testIndexingWithLegacyConfiguration() {
        org.infinispan.config.Configuration configuration = new org.infinispan.config.Configuration();
        configuration.setIndexingEnabled(true);
        configuration.setIndexLocalOnly(true);
        configuration.getIndexingProperties().put((Object)"default.directory_provider", (Object)"ram");
        configuration.getIndexingProperties().put((Object)"lucene_version", (Object)"LUCENE_CURRENT");
        Configuration legacy = LegacyConfigurationAdaptor.adapt((org.infinispan.config.Configuration)configuration);
        assert (legacy.indexing().enabled());
        assert (legacy.indexing().indexLocalOnly());
        TypedProperties p = legacy.indexing().properties();
        AssertJUnit.assertEquals((String)"ram", (String)p.getProperty("default.directory_provider"));
        AssertJUnit.assertEquals((String)"LUCENE_CURRENT", (String)p.getProperty("lucene_version"));
    }
}

