/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.searchmanager;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Query;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.Search;
import org.infinispan.query.SearchManager;
import org.infinispan.query.helper.TestQueryHelperFactory;
import org.infinispan.test.MultipleCacheManagersTest;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.searchmanager.ClusteredCacheQueryTimeoutTest")
public class ClusteredCacheQueryTimeoutTest
extends MultipleCacheManagersTest {
    private Cache cache1;

    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder cacheCfg = ClusteredCacheQueryTimeoutTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.REPL_SYNC, (boolean)false);
        cacheCfg.indexing().enable().indexLocalOnly(true).addProperty("default.directory_provider", "ram").addProperty("lucene_version", "LUCENE_CURRENT");
        List caches = this.createClusteredCaches(2, cacheCfg);
        this.cache1 = (Cache)caches.get(0);
    }

    @Test(expectedExceptions={UnsupportedOperationException.class}, expectedExceptionsMessageRegExp="Clustered queries do not support timeouts yet.")
    public void testClusteredQueryCacheTimeout() throws Exception {
        SearchManager searchManager = Search.getSearchManager((Cache)this.cache1);
        QueryParser queryParser = TestQueryHelperFactory.createQueryParser("bar");
        Query luceneQuery = queryParser.parse("fakebar");
        CacheQuery query = searchManager.getClusteredQuery(luceneQuery, new Class[]{Foo.class});
        query.timeout(1L, TimeUnit.NANOSECONDS);
    }

    @Indexed(index="FooIndex")
    public class Foo {
        private String bar;

        public Foo(String bar) {
            this.bar = bar;
        }

        @Field(name="bar")
        public String getBar() {
            return this.bar;
        }
    }
}

