/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.config;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import junit.framework.Assert;
import org.apache.lucene.queryParser.ParseException;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.indexes.impl.DirectoryBasedIndexManager;
import org.hibernate.search.indexes.spi.IndexManager;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.store.impl.RAMDirectoryProvider;
import org.infinispan.Cache;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.Search;
import org.infinispan.query.SearchManager;
import org.infinispan.query.helper.TestQueryHelperFactory;
import org.infinispan.query.test.Person;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="query.config.MultipleCachesTest")
public class MultipleCachesTest
extends SingleCacheManagerTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected EmbeddedCacheManager createCacheManager() throws Exception {
        EmbeddedCacheManager cm;
        String config = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<infinispan\n      xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n      xsi:schemaLocation=\"urn:infinispan:config:5.3 http://www.infinispan.org/schemas/infinispan-config-5.3.xsd\"\n      xmlns=\"urn:infinispan:config:5.3\">\n   <default>\n      <indexing enabled=\"false\" />\n   </default>\n   <namedCache name=\"indexingenabled\">\n      <indexing enabled=\"true\" >\n         <properties>\n            <property name=\"default.directory_provider\" value=\"ram\" />\n            <property name=\"lucene_version\" value=\"LUCENE_CURRENT\" />\n         </properties>\n      </indexing>\n   </namedCache>\n</infinispan>";
        System.out.println("Using test configuration:\n\n" + config + "\n");
        ByteArrayInputStream is = new ByteArrayInputStream(config.getBytes());
        try {
            cm = TestCacheManagerFactory.fromStream((InputStream)is);
        }
        finally {
            ((InputStream)is).close();
        }
        this.cache = cm.getCache();
        return cm;
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void queryNotIndexedCache() throws ParseException {
        Cache notIndexedCache = this.cacheManager.getCache("notIndexedA");
        notIndexedCache.put((Object)"1", (Object)new Person("A Person's Name", "A paragraph containing some text", 75));
        CacheQuery cq = TestQueryHelperFactory.createCacheQuery(this.cache, "name", "Name");
        Assert.assertEquals((int)1, (int)cq.getResultSize());
        List l = cq.list();
        Assert.assertEquals((int)1, (int)l.size());
        Person p = (Person)l.get(0);
        Assert.assertEquals((String)"A Person's Name", (String)p.getName());
        Assert.assertEquals((String)"A paragraph containing some text", (String)p.getBlurb());
        Assert.assertEquals((int)75, (int)p.getAge());
    }

    @Test
    public void notIndexedCacheNormalUse() {
        Cache notIndexedCache = this.cacheManager.getCache("notIndexedB");
        notIndexedCache.put((Object)"1", (Object)new Person("A Person's Name", "A paragraph containing some text", 75));
        assert (notIndexedCache.get((Object)"1") != null);
    }

    @Test
    public void indexedCache() throws ParseException {
        Cache indexedCache = this.cacheManager.getCache("indexingenabled");
        this.useQuery((Cache<Object, Object>)indexedCache);
    }

    private void useQuery(Cache<Object, Object> indexedCache) throws ParseException {
        indexedCache.put((Object)"1", (Object)new Person("A Person's Name", "A paragraph containing some text", 75));
        CacheQuery cq = TestQueryHelperFactory.createCacheQuery(indexedCache, "name", "Name");
        Assert.assertEquals((int)1, (int)cq.getResultSize());
        List l = cq.list();
        Assert.assertEquals((int)1, (int)l.size());
        Person p = (Person)l.get(0);
        Assert.assertEquals((String)"A Person's Name", (String)p.getName());
        Assert.assertEquals((String)"A paragraph containing some text", (String)p.getBlurb());
        Assert.assertEquals((int)75, (int)p.getAge());
        SearchManager queryFactory = Search.getSearchManager(indexedCache);
        SearchFactoryImplementor searchImpl = (SearchFactoryImplementor)queryFactory.getSearchFactory();
        IndexManager[] indexManagers = searchImpl.getIndexBindingForEntity(Person.class).getIndexManagers();
        assert (indexManagers != null && indexManagers.length == 1);
        DirectoryBasedIndexManager directory = (DirectoryBasedIndexManager)indexManagers[0];
        DirectoryProvider directoryProvider = directory.getDirectoryProvider();
        assert (directoryProvider instanceof RAMDirectoryProvider) : "configuration properties where ignored";
    }
}

