/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.backend;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import org.hibernate.search.backend.TransactionContext;
import org.hibernate.search.backend.spi.Work;
import org.hibernate.search.backend.spi.WorkType;
import org.hibernate.search.backend.spi.Worker;
import org.hibernate.search.engine.spi.EntityIndexBinder;
import org.hibernate.search.spi.SearchFactoryIntegrator;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.marshall.MarshalledValue;
import org.infinispan.query.Transformer;
import org.infinispan.query.backend.KeyTransformationHandler;
import org.infinispan.query.backend.SearchWorkCreator;
import org.infinispan.query.backend.TransactionalEventTransactionContext;
import org.infinispan.query.impl.DefaultSearchWorkCreator;
import org.infinispan.query.logging.Log;
import org.infinispan.util.CollectionFactory;
import org.infinispan.util.logging.LogFactory;

public class QueryInterceptor
extends CommandInterceptor {
    private final SearchFactoryIntegrator searchFactory;
    private final ConcurrentMap<Class<?>, Boolean> knownClasses = CollectionFactory.makeConcurrentMap();
    private final Lock mutating = new ReentrantLock();
    private final KeyTransformationHandler keyTransformationHandler = new KeyTransformationHandler();
    private SearchWorkCreator<Object> searchWorkCreator = new DefaultSearchWorkCreator<Object>();
    private DataContainer dataContainer;
    protected TransactionManager transactionManager;
    protected TransactionSynchronizationRegistry transactionSynchronizationRegistry;
    protected ExecutorService asyncExecutor;
    private static final Log log = (Log)LogFactory.getLog(QueryInterceptor.class, Log.class);

    protected Log getLog() {
        return log;
    }

    public QueryInterceptor(SearchFactoryIntegrator searchFactory) {
        this.searchFactory = searchFactory;
    }

    @Inject
    public void injectDependencies(TransactionManager transactionManager, TransactionSynchronizationRegistry transactionSynchronizationRegistry, DataContainer dataContainer, @ComponentName(value="org.infinispan.executors.transport") ExecutorService e) {
        this.transactionManager = transactionManager;
        this.transactionSynchronizationRegistry = transactionSynchronizationRegistry;
        this.asyncExecutor = e;
        this.dataContainer = dataContainer;
    }

    protected boolean shouldModifyIndexes(FlagAffectedCommand command, InvocationContext ctx) {
        return !command.hasFlag(Flag.SKIP_INDEXING);
    }

    public ExecutorService getAsyncExecutor() {
        return this.asyncExecutor;
    }

    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        Object toReturn = this.invokeNextInterceptor(ctx, (VisitableCommand)command);
        this.processPutKeyValueCommand(command, ctx, toReturn, null);
        return toReturn;
    }

    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        Object valueRemoved = this.invokeNextInterceptor(ctx, (VisitableCommand)command);
        this.processRemoveCommand(command, ctx, valueRemoved, null);
        return valueRemoved;
    }

    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        Object valueReplaced = this.invokeNextInterceptor(ctx, (VisitableCommand)command);
        this.processReplaceCommand(command, ctx, valueReplaced, null);
        return valueReplaced;
    }

    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        Object mapPut = this.invokeNextInterceptor(ctx, (VisitableCommand)command);
        this.processPutMapCommand(command, ctx, null);
        return mapPut;
    }

    public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        Object returnValue = this.invokeNextInterceptor(ctx, (VisitableCommand)command);
        this.processClearCommand(command, ctx, null);
        return returnValue;
    }

    public void purgeAllIndexes() {
        this.purgeAllIndexes(null);
    }

    private void purgeAllIndexes(TransactionContext transactionContext) {
        transactionContext = transactionContext == null ? this.makeTransactionalEventContext() : transactionContext;
        for (Class c : this.knownClasses.keySet()) {
            if (!this.isIndexed(c)) continue;
            this.performSearchWorks(this.searchWorkCreator.createPerEntityTypeWorks(c, WorkType.PURGE_ALL), transactionContext);
        }
    }

    protected void removeFromIndexes(Object value, Object key, TransactionContext transactionContext) {
        this.performSearchWork(value, (Serializable)((Object)this.keyToString(key)), WorkType.DELETE, transactionContext);
    }

    protected void updateIndexes(Object value, Object key, TransactionContext transactionContext) {
        this.performSearchWork(value, (Serializable)((Object)this.keyToString(key)), WorkType.UPDATE, transactionContext);
    }

    private void performSearchWork(Object value, Serializable id, WorkType workType, TransactionContext transactionContext) {
        if (value == null) {
            throw new NullPointerException("Cannot handle a null value!");
        }
        Collection works = this.searchWorkCreator.createPerEntityWorks(value, id, workType);
        this.performSearchWorks(works, transactionContext);
    }

    private <T> void performSearchWorks(Collection<Work<T>> works, TransactionContext transactionContext) {
        Worker worker = this.searchFactory.getWorker();
        for (Work<T> work : works) {
            worker.performWork(work, transactionContext);
        }
    }

    private boolean isIndexed(Class<?> c) {
        EntityIndexBinder binder = this.searchFactory.getIndexBindingForEntity(c);
        return binder != null;
    }

    private Object extractValue(Object wrappedValue) {
        if (wrappedValue instanceof MarshalledValue) {
            return ((MarshalledValue)wrappedValue).get();
        }
        return wrappedValue;
    }

    public void enableClasses(Class<?>[] classes) {
        if (classes == null || classes.length == 0) {
            return;
        }
        this.enableClassesIncrementally(classes, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void enableClassesIncrementally(Class<?>[] classes, boolean locked) {
        void var6_8;
        ArrayList toAdd = null;
        Class<?>[] arr$ = classes;
        int len$ = arr$.length;
        boolean bl = false;
        while (var6_8 < len$) {
            Class<?> type = arr$[var6_8];
            if (!this.knownClasses.containsKey(type)) {
                if (toAdd == null) {
                    toAdd = new ArrayList(classes.length);
                }
                toAdd.add(type);
            }
            ++var6_8;
        }
        if (toAdd == null) {
            return;
        }
        if (locked) {
            Class[] array = toAdd.toArray(new Class[toAdd.size()]);
            this.searchFactory.addClasses(array);
            for (Class clazz : toAdd) {
                this.knownClasses.put(clazz, this.isIndexed(clazz));
            }
        } else {
            this.mutating.lock();
            try {
                this.enableClassesIncrementally(classes, true);
            }
            finally {
                this.mutating.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateKnownTypesIfNeeded(Object value) {
        if (value != null) {
            Class<?> potentialNewType = value.getClass();
            if (!this.knownClasses.containsKey(potentialNewType)) {
                this.mutating.lock();
                try {
                    this.enableClassesIncrementally(new Class[]{potentialNewType}, true);
                }
                finally {
                    this.mutating.unlock();
                }
            }
            return (Boolean)this.knownClasses.get(potentialNewType);
        }
        return false;
    }

    public void registerKeyTransformer(Class<?> keyClass, Class<? extends Transformer> transformerClass) {
        this.keyTransformationHandler.registerTransformer(keyClass, transformerClass);
    }

    private String keyToString(Object key) {
        return this.keyTransformationHandler.keyToString(key);
    }

    public KeyTransformationHandler getKeyTransformationHandler() {
        return this.keyTransformationHandler;
    }

    public void enableClasses(Set<Class> knownIndexedTypes) {
        Class[] classes = knownIndexedTypes.toArray(new Class[knownIndexedTypes.size()]);
        this.enableClasses(classes);
    }

    public SearchFactoryIntegrator getSearchFactory() {
        return this.searchFactory;
    }

    public void setSearchWorkCreator(SearchWorkCreator<Object> searchWorkCreator) {
        this.searchWorkCreator = searchWorkCreator;
    }

    public SearchWorkCreator<Object> getSearchWorkCreator() {
        return this.searchWorkCreator;
    }

    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        WriteCommand[] writeCommands = command.getModifications();
        Object[] stateBeforePrepare = new Object[writeCommands.length];
        for (int i = 0; i < writeCommands.length; ++i) {
            InternalCacheEntry internalCacheEntry;
            WriteCommand writeCommand = writeCommands[i];
            if (writeCommand instanceof PutKeyValueCommand) {
                internalCacheEntry = this.dataContainer.get(((PutKeyValueCommand)writeCommand).getKey());
                stateBeforePrepare[i] = internalCacheEntry != null ? internalCacheEntry.getValue() : null;
                continue;
            }
            if (writeCommand instanceof PutMapCommand) continue;
            if (writeCommand instanceof RemoveCommand) {
                internalCacheEntry = this.dataContainer.get(((RemoveCommand)writeCommand).getKey());
                stateBeforePrepare[i] = internalCacheEntry != null ? internalCacheEntry.getValue() : null;
                continue;
            }
            if (!(writeCommand instanceof ReplaceCommand)) continue;
            internalCacheEntry = this.dataContainer.get(((ReplaceCommand)writeCommand).getKey());
            stateBeforePrepare[i] = internalCacheEntry != null ? internalCacheEntry.getValue() : null;
        }
        Object toReturn = super.visitPrepareCommand(ctx, command);
        if (ctx.isTransactionValid()) {
            TransactionContext transactionContext = this.makeTransactionalEventContext();
            for (int i = 0; i < writeCommands.length; ++i) {
                WriteCommand writeCommand = writeCommands[i];
                if (writeCommand instanceof PutKeyValueCommand) {
                    this.processPutKeyValueCommand((PutKeyValueCommand)writeCommand, (InvocationContext)ctx, stateBeforePrepare[i], transactionContext);
                    continue;
                }
                if (writeCommand instanceof PutMapCommand) {
                    this.processPutMapCommand((PutMapCommand)writeCommand, (InvocationContext)ctx, transactionContext);
                    continue;
                }
                if (writeCommand instanceof RemoveCommand) {
                    this.processRemoveCommand((RemoveCommand)writeCommand, (InvocationContext)ctx, stateBeforePrepare[i], transactionContext);
                    continue;
                }
                if (writeCommand instanceof ReplaceCommand) {
                    this.processReplaceCommand((ReplaceCommand)writeCommand, (InvocationContext)ctx, stateBeforePrepare[i], transactionContext);
                    continue;
                }
                if (!(writeCommand instanceof ClearCommand)) continue;
                this.processClearCommand((ClearCommand)writeCommand, (InvocationContext)ctx, transactionContext);
            }
        }
        return toReturn;
    }

    private void processReplaceCommand(ReplaceCommand command, InvocationContext ctx, Object valueReplaced, TransactionContext transactionContext) {
        if (valueReplaced != null && command.isSuccessful() && this.shouldModifyIndexes((FlagAffectedCommand)command, ctx)) {
            Object[] parameters = command.getParameters();
            Object p1 = this.extractValue(parameters[1]);
            Object p2 = this.extractValue(parameters[2]);
            boolean originalIsIndexed = this.updateKnownTypesIfNeeded(p1);
            boolean newValueIsIndexed = this.updateKnownTypesIfNeeded(p2);
            Object key = this.extractValue(command.getKey());
            if (p1 != null && originalIsIndexed) {
                transactionContext = transactionContext == null ? this.makeTransactionalEventContext() : transactionContext;
                this.removeFromIndexes(p1, key, transactionContext);
            }
            if (newValueIsIndexed) {
                transactionContext = transactionContext == null ? this.makeTransactionalEventContext() : transactionContext;
                this.updateIndexes(p2, key, transactionContext);
            }
        }
    }

    private void processRemoveCommand(RemoveCommand command, InvocationContext ctx, Object valueRemoved, TransactionContext transactionContext) {
        Object value;
        if (command.isSuccessful() && !command.isNonExistent() && this.shouldModifyIndexes((FlagAffectedCommand)command, ctx) && this.updateKnownTypesIfNeeded(value = this.extractValue(valueRemoved))) {
            transactionContext = transactionContext == null ? this.makeTransactionalEventContext() : transactionContext;
            this.removeFromIndexes(value, this.extractValue(command.getKey()), transactionContext);
        }
    }

    private void processPutMapCommand(PutMapCommand command, InvocationContext ctx, TransactionContext transactionContext) {
        if (this.shouldModifyIndexes((FlagAffectedCommand)command, ctx)) {
            Map dataMap = command.getMap();
            for (Map.Entry entry : dataMap.entrySet()) {
                Object value = this.extractValue(entry.getValue());
                if (!this.updateKnownTypesIfNeeded(value)) continue;
                transactionContext = transactionContext == null ? this.makeTransactionalEventContext() : transactionContext;
                this.updateIndexes(value, this.extractValue(entry.getKey()), transactionContext);
            }
        }
    }

    private void processPutKeyValueCommand(PutKeyValueCommand command, InvocationContext ctx, Object previousValue, TransactionContext transactionContext) {
        Object value;
        if (this.updateKnownTypesIfNeeded(previousValue) && this.shouldModifyIndexes((FlagAffectedCommand)command, ctx)) {
            transactionContext = transactionContext == null ? this.makeTransactionalEventContext() : transactionContext;
            this.removeFromIndexes(previousValue, this.extractValue(command.getKey()), transactionContext);
        }
        if (this.updateKnownTypesIfNeeded(value = this.extractValue(command.getValue())) && this.shouldModifyIndexes((FlagAffectedCommand)command, ctx)) {
            transactionContext = transactionContext == null ? this.makeTransactionalEventContext() : transactionContext;
            this.updateIndexes(value, this.extractValue(command.getKey()), transactionContext);
        }
    }

    private void processClearCommand(ClearCommand command, InvocationContext ctx, TransactionContext transactionContext) {
        if (this.shouldModifyIndexes((FlagAffectedCommand)command, ctx)) {
            this.purgeAllIndexes(transactionContext);
        }
    }

    private final TransactionContext makeTransactionalEventContext() {
        return new TransactionalEventTransactionContext(this.transactionManager, this.transactionSynchronizationRegistry);
    }
}

