/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.impl;

import java.util.Collection;
import org.infinispan.query.dsl.FilterConditionBeginContext;
import org.infinispan.query.dsl.FilterConditionContext;
import org.infinispan.query.dsl.FilterConditionEndContext;
import org.infinispan.query.dsl.RangeConditionContext;
import org.infinispan.query.dsl.impl.BaseCondition;
import org.infinispan.query.dsl.impl.ValueRange;
import org.infinispan.query.dsl.impl.Visitor;

class AttributeCondition
extends BaseCondition
implements FilterConditionBeginContext,
FilterConditionEndContext,
RangeConditionContext {
    private Operator operator;
    private Object argument;
    private String attributePath;
    private boolean isNegated;

    @Override
    public <ReturnType> ReturnType accept(Visitor<ReturnType> visitor) {
        return visitor.visit(this);
    }

    Operator getOperator() {
        return this.operator;
    }

    Object getArgument() {
        return this.argument;
    }

    String getAttributePath() {
        return this.attributePath;
    }

    boolean isNegated() {
        return this.isNegated;
    }

    @Override
    public FilterConditionEndContext having(String attributePath) {
        if (attributePath == null) {
            throw new IllegalArgumentException("attribute path cannot be null");
        }
        if (this.attributePath != null) {
            throw new IllegalStateException("attribute path was already specified");
        }
        this.attributePath = attributePath;
        return this;
    }

    @Override
    public FilterConditionBeginContext not() {
        this.isNegated = !this.isNegated;
        return this;
    }

    @Override
    public FilterConditionContext in(Object ... value) {
        this.setOperatorAndArgument(Operator.IN, value);
        return this;
    }

    @Override
    public FilterConditionContext in(Collection values) {
        this.setOperatorAndArgument(Operator.IN, values);
        return this;
    }

    @Override
    public FilterConditionContext like(String pattern) {
        this.setOperatorAndArgument(Operator.LIKE, pattern);
        return this;
    }

    @Override
    public FilterConditionContext contains(Object value) {
        this.setOperatorAndArgument(Operator.CONTAINS, value);
        return this;
    }

    @Override
    public FilterConditionContext containsAll(Object ... value) {
        this.setOperatorAndArgument(Operator.CONTAINS_ALL, value);
        return this;
    }

    @Override
    public FilterConditionContext containsAll(Collection values) {
        this.setOperatorAndArgument(Operator.CONTAINS_ALL, values);
        return this;
    }

    @Override
    public FilterConditionContext containsAny(Object ... value) {
        this.setOperatorAndArgument(Operator.CONTAINS_ANY, value);
        return this;
    }

    @Override
    public FilterConditionContext containsAny(Collection values) {
        this.setOperatorAndArgument(Operator.CONTAINS_ANY, values);
        return this;
    }

    @Override
    public FilterConditionContext isNull() {
        this.setOperatorAndArgument(Operator.IS_NULL, null);
        return this;
    }

    @Override
    public FilterConditionContext eq(Object value) {
        this.setOperatorAndArgument(Operator.EQ, value);
        return this;
    }

    @Override
    public FilterConditionContext lt(Object value) {
        this.setOperatorAndArgument(Operator.LT, value);
        return this;
    }

    @Override
    public FilterConditionContext lte(Object value) {
        this.setOperatorAndArgument(Operator.LTE, value);
        return this;
    }

    @Override
    public FilterConditionContext gt(Object value) {
        this.setOperatorAndArgument(Operator.GT, value);
        return this;
    }

    @Override
    public FilterConditionContext gte(Object value) {
        this.setOperatorAndArgument(Operator.GTE, value);
        return this;
    }

    @Override
    public RangeConditionContext between(Object from, Object to) {
        ValueRange valueRange = new ValueRange(from, to);
        this.setOperatorAndArgument(Operator.BETWEEN, valueRange);
        return this;
    }

    @Override
    public RangeConditionContext includeLower(boolean includeLower) {
        ValueRange valueRange = (ValueRange)this.argument;
        valueRange.setIncludeLower(includeLower);
        return this;
    }

    @Override
    public RangeConditionContext includeUpper(boolean includeUpper) {
        ValueRange valueRange = (ValueRange)this.argument;
        valueRange.setIncludeUpper(includeUpper);
        return this;
    }

    private void setOperatorAndArgument(Operator operator, Object argument) {
        if (argument == null) {
            throw new IllegalArgumentException("argument cannot be null");
        }
        if (this.operator != null) {
            throw new IllegalStateException("operator was already specified");
        }
        this.operator = operator;
        this.argument = argument;
    }

    public String toString() {
        return "AttributeCondition{isNegated=" + this.isNegated + ", attributePath='" + this.attributePath + '\'' + ", operator=" + (Object)((Object)this.operator) + ", argument=" + this.argument + '}';
    }

    protected static enum Operator {
        IN,
        LIKE,
        CONTAINS,
        CONTAINS_ALL,
        CONTAINS_ANY,
        IS_NULL,
        EQ,
        LT,
        LTE,
        GT,
        GTE,
        BETWEEN;

    }
}

