/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.impl;

import java.util.List;
import org.hibernate.hql.lucene.LuceneQueryParsingResult;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.FetchOptions;
import org.infinispan.query.ResultIterator;
import org.infinispan.query.SearchManager;
import org.infinispan.query.dsl.Query;

class LuceneQuery
implements Query {
    private final SearchManager sm;
    private final LuceneQueryParsingResult parsingResult;
    private CacheQuery cacheQuery = null;

    public LuceneQuery(SearchManager sm, LuceneQueryParsingResult parsingResult) {
        this.sm = sm;
        this.parsingResult = parsingResult;
    }

    private CacheQuery getCacheQuery() {
        if (this.cacheQuery == null) {
            this.cacheQuery = this.sm.getQuery(this.parsingResult.getQuery(), this.parsingResult.getTargetEntity());
        }
        return this.cacheQuery;
    }

    @Override
    public <T> List<T> list() {
        return this.getCacheQuery().list();
    }

    @Override
    public ResultIterator iterator(FetchOptions fetchOptions) {
        return this.getCacheQuery().iterator(fetchOptions);
    }

    @Override
    public ResultIterator iterator() {
        return this.getCacheQuery().iterator();
    }

    @Override
    public int getResultSize() {
        return this.getCacheQuery().getResultSize();
    }

    public String toString() {
        return "Lucene Query: " + this.parsingResult;
    }
}

