/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.impl;

import org.hibernate.hql.QueryParser;
import org.hibernate.hql.ast.spi.AstProcessingChain;
import org.hibernate.hql.ast.spi.EntityNamesResolver;
import org.hibernate.hql.lucene.LuceneProcessingChain;
import org.hibernate.hql.lucene.LuceneQueryParsingResult;
import org.hibernate.search.spi.SearchFactoryIntegrator;
import org.infinispan.query.SearchManager;
import org.infinispan.query.dsl.FilterConditionBeginContext;
import org.infinispan.query.dsl.FilterConditionEndContext;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryBuilder;
import org.infinispan.query.dsl.SortOrder;
import org.infinispan.query.dsl.impl.AttributeCondition;
import org.infinispan.query.dsl.impl.JPAQueryGeneratorVisitor;
import org.infinispan.query.dsl.impl.LuceneQuery;
import org.infinispan.query.dsl.impl.Visitable;
import org.infinispan.query.dsl.impl.Visitor;

class LuceneQueryBuilder
implements QueryBuilder,
Visitable {
    private final SearchManager searchManager;
    private final EntityNamesResolver entityNamesResolver;
    private final Class rootType;
    private AttributeCondition filterCondition;
    private long startOffset = -1L;
    private int maxResults = -1;

    public LuceneQueryBuilder(SearchManager searchManager, EntityNamesResolver entityNamesResolver, Class rootType) {
        this.searchManager = searchManager;
        this.entityNamesResolver = entityNamesResolver;
        this.rootType = rootType;
    }

    @Override
    public QueryBuilder orderBy(String attributePath, SortOrder sortOrder) {
        return this;
    }

    @Override
    public QueryBuilder setProjection(String ... attributePath) {
        return this;
    }

    @Override
    public QueryBuilder startOffset(long startOffset) {
        this.startOffset = startOffset;
        return this;
    }

    @Override
    public QueryBuilder maxResults(int maxResults) {
        this.maxResults = maxResults;
        return this;
    }

    @Override
    public Class getRootType() {
        return this.rootType;
    }

    AttributeCondition getFilterCondition() {
        return this.filterCondition;
    }

    @Override
    public Query build() {
        String jpaQuery = this.accept(new JPAQueryGeneratorVisitor());
        LuceneProcessingChain processingChain = new LuceneProcessingChain((SearchFactoryIntegrator)this.searchManager.getSearchFactory(), this.entityNamesResolver, null);
        QueryParser queryParser = new QueryParser();
        LuceneQueryParsingResult parsingResult = (LuceneQueryParsingResult)queryParser.parseQuery(jpaQuery, (AstProcessingChain)processingChain);
        return new LuceneQuery(this.searchManager, parsingResult);
    }

    @Override
    public FilterConditionEndContext having(String attributePath) {
        if (this.filterCondition != null) {
            throw new IllegalStateException("Sentence already started. Cannot use 'having(..)' again.");
        }
        this.filterCondition = new AttributeCondition();
        this.filterCondition.setQueryBuilder(this);
        return this.filterCondition.having(attributePath);
    }

    @Override
    public FilterConditionBeginContext not() {
        if (this.filterCondition != null) {
            throw new IllegalStateException("Sentence already started. Cannot use 'not()' again.");
        }
        this.filterCondition = new AttributeCondition();
        this.filterCondition.setQueryBuilder(this);
        return this.filterCondition.not();
    }

    @Override
    public <ReturnType> ReturnType accept(Visitor<ReturnType> visitor) {
        return visitor.visit(this);
    }
}

