/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.blackbox;

import java.util.HashMap;
import java.util.List;
import javax.transaction.TransactionManager;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Query;
import org.hibernate.search.FullTextFilter;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.FetchOptions;
import org.infinispan.query.ResultIterator;
import org.infinispan.query.Search;
import org.infinispan.query.SearchManager;
import org.infinispan.query.backend.QueryInterceptor;
import org.infinispan.query.helper.TestQueryHelperFactory;
import org.infinispan.query.test.CustomKey3;
import org.infinispan.query.test.CustomKey3Transformer;
import org.infinispan.query.test.Person;
import org.infinispan.test.AbstractCacheTest;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.blackbox.ClusteredCacheTest")
public class ClusteredCacheTest
extends MultipleCacheManagersTest {
    Cache<String, Person> cache1;
    Cache<String, Person> cache2;
    Person person1;
    Person person2;
    Person person3;
    Person person4;
    QueryParser queryParser;
    Query luceneQuery;
    CacheQuery cacheQuery;
    final String key1 = "Navin";
    final String key2 = "BigGoat";
    final String key3 = "MiniGoat";

    public ClusteredCacheTest() {
        this.cleanup = AbstractCacheTest.CleanupPhase.AFTER_METHOD;
    }

    protected void enhanceConfig(ConfigurationBuilder cacheCfg) {
    }

    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder cacheCfg = ClusteredCacheTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.REPL_SYNC, (boolean)this.transactionsEnabled());
        cacheCfg.indexing().enable().indexLocalOnly(false).addProperty("default.directory_provider", "ram").addProperty("lucene_version", "LUCENE_CURRENT");
        this.enhanceConfig(cacheCfg);
        List caches = this.createClusteredCaches(2, cacheCfg);
        this.cache1 = (Cache)caches.get(0);
        this.cache2 = (Cache)caches.get(1);
    }

    private void prepareTestedObjects() {
        this.person1 = new Person();
        this.person1.setName("Navin Surtani");
        this.person1.setBlurb("Likes playing WoW");
        this.person1.setAge(30);
        this.person2 = new Person();
        this.person2.setName("BigGoat");
        this.person2.setBlurb("Eats grass");
        this.person2.setAge(22);
        this.person3 = new Person();
        this.person3.setName("MiniGoat");
        this.person3.setBlurb("Eats cheese");
        this.person3.setAge(15);
    }

    protected void prepareTestData() throws Exception {
        this.prepareTestedObjects();
        TransactionManager transactionManager = null;
        transactionManager = this.cache1.getAdvancedCache().getTransactionManager();
        if (this.transactionsEnabled()) {
            transactionManager.begin();
        }
        this.cache1.put((Object)"Navin", (Object)this.person1);
        this.cache1.put((Object)"BigGoat", (Object)this.person2);
        this.cache1.put((Object)"MiniGoat", (Object)this.person3);
        if (this.transactionsEnabled()) {
            transactionManager.commit();
        }
    }

    protected boolean transactionsEnabled() {
        return false;
    }

    public void testSimple() throws Exception {
        this.prepareTestData();
        this.cacheQuery = TestQueryHelperFactory.createCacheQuery(this.cache2, "blurb", "playing");
        List found = this.cacheQuery.list();
        assert (found.size() == 1);
        if (found.get(0) == null) {
            this.log.warn((Object)"found.get(0) is null");
            Person p1 = (Person)this.cache2.get((Object)"Navin");
            if (p1 == null) {
                this.log.warn((Object)"Person p1 is null in sc2 and cannot actually see the data of person1 in sc1");
            } else {
                this.log.trace((Object)("p1 name is  " + p1.getName()));
            }
        }
        assert (found.get(0).equals(this.person1));
    }

    private void assertQueryInterceptorPresent(Cache<?, ?> c) {
        CommandInterceptor i = TestingUtil.findInterceptor(c, QueryInterceptor.class);
        assert (i != null) : "Expected to find a QueryInterceptor, only found " + c.getAdvancedCache().getInterceptorChain();
    }

    public void testModified() throws Exception {
        this.prepareTestData();
        this.assertQueryInterceptorPresent(this.cache2);
        this.queryParser = TestQueryHelperFactory.createQueryParser("blurb");
        this.luceneQuery = this.queryParser.parse("playing");
        this.cacheQuery = Search.getSearchManager(this.cache2).getQuery(this.luceneQuery, new Class[0]);
        List found = this.cacheQuery.list();
        assert (found.size() == 1) : "Expected list of size 1, was of size " + found.size();
        assert (found.get(0).equals(this.person1));
        this.person1.setBlurb("Likes pizza");
        this.cache1.put((Object)"Navin", (Object)this.person1);
        this.queryParser = TestQueryHelperFactory.createQueryParser("blurb");
        this.luceneQuery = this.queryParser.parse("pizza");
        this.cacheQuery = Search.getSearchManager(this.cache2).getQuery(this.luceneQuery, new Class[0]);
        found = this.cacheQuery.list();
        assert (found.size() == 1);
        assert (found.get(0).equals(this.person1));
    }

    public void testAdded() throws Exception {
        this.prepareTestData();
        this.queryParser = TestQueryHelperFactory.createQueryParser("blurb");
        this.luceneQuery = this.queryParser.parse("eats");
        this.cacheQuery = Search.getSearchManager(this.cache2).getQuery(this.luceneQuery, new Class[0]);
        List found = this.cacheQuery.list();
        AssertJUnit.assertEquals((int)2, (int)found.size());
        assert (found.contains(this.person2));
        assert (found.contains(this.person3));
        assert (!found.contains(this.person4)) : "This should not contain object person4";
        this.person4 = new Person();
        this.person4.setName("Mighty Goat");
        this.person4.setBlurb("Also eats grass");
        this.cache1.put((Object)"mighty", (Object)this.person4);
        this.luceneQuery = this.queryParser.parse("eats");
        this.cacheQuery = Search.getSearchManager(this.cache2).getQuery(this.luceneQuery, new Class[0]);
        found = this.cacheQuery.list();
        AssertJUnit.assertEquals((int)3, (int)found.size());
        assert (found.contains(this.person2));
        assert (found.contains(this.person3));
        assert (found.contains(this.person4)) : "This should now contain object person4";
    }

    public void testRemoved() throws Exception {
        this.prepareTestData();
        this.queryParser = TestQueryHelperFactory.createQueryParser("blurb");
        this.luceneQuery = this.queryParser.parse("eats");
        this.cacheQuery = Search.getSearchManager(this.cache2).getQuery(this.luceneQuery, new Class[0]);
        List found = this.cacheQuery.list();
        assert (found.size() == 2);
        assert (found.contains(this.person2));
        assert (found.contains(this.person3)) : "This should still contain object person3";
        this.cache1.remove((Object)"MiniGoat");
        found = this.cacheQuery.list();
        assert (found.size() == 1);
        assert (found.contains(this.person2));
        assert (!found.contains(this.person3)) : "This should not contain object person3 anymore";
    }

    public void testGetResultSize() throws Exception {
        this.prepareTestData();
        this.queryParser = TestQueryHelperFactory.createQueryParser("blurb");
        this.luceneQuery = this.queryParser.parse("playing");
        this.cacheQuery = Search.getSearchManager(this.cache2).getQuery(this.luceneQuery, new Class[0]);
        List found = this.cacheQuery.list();
        AssertJUnit.assertEquals((int)1, (int)found.size());
    }

    public void testPutMap() throws Exception {
        this.prepareTestData();
        SearchManager searchManager = Search.getSearchManager(this.cache2);
        QueryBuilder queryBuilder = searchManager.buildQueryBuilderForClass(Person.class).get();
        Query allQuery = queryBuilder.all().createQuery();
        assert (searchManager.getQuery(allQuery, new Class[]{Person.class}).list().size() == 3);
        HashMap<String, Person> allWrites = new HashMap<String, Person>();
        allWrites.put("Navin", this.person1);
        allWrites.put("BigGoat", this.person2);
        allWrites.put("MiniGoat", this.person3);
        this.cache2.putAll(allWrites);
        List found = searchManager.getQuery(allQuery, new Class[]{Person.class}).list();
        AssertJUnit.assertEquals((int)3, (int)found.size());
        this.cache2.putAll(allWrites);
        found = searchManager.getQuery(allQuery, new Class[]{Person.class}).list();
        AssertJUnit.assertEquals((int)3, (int)found.size());
    }

    public void testClear() throws Exception {
        this.prepareTestData();
        this.queryParser = TestQueryHelperFactory.createQueryParser("blurb");
        this.luceneQuery = this.queryParser.parse("eats");
        this.cacheQuery = Search.getSearchManager(this.cache1).getQuery(this.luceneQuery, new Class[0]);
        this.luceneQuery = this.queryParser.parse("playing");
        Query[] queries = new Query[]{this.luceneQuery, this.luceneQuery};
        Query luceneQuery = queries[0].combine(queries);
        CacheQuery cacheQuery = Search.getSearchManager(this.cache1).getQuery(luceneQuery, new Class[0]);
        AssertJUnit.assertEquals((int)3, (int)cacheQuery.getResultSize());
        this.cache2.clear();
        AssertJUnit.assertEquals((int)3, (int)cacheQuery.getResultSize());
        cacheQuery = Search.getSearchManager(this.cache1).getQuery(luceneQuery, new Class[0]);
        AssertJUnit.assertEquals((int)0, (int)cacheQuery.getResultSize());
    }

    public void testFullTextFilterOnOff() throws Exception {
        this.prepareTestData();
        this.queryParser = TestQueryHelperFactory.createQueryParser("blurb");
        Query luceneQuery = this.queryParser.parse("eats");
        CacheQuery query = Search.getSearchManager(this.cache1).getQuery(luceneQuery, new Class[0]);
        FullTextFilter filter = query.enableFullTextFilter("personFilter");
        filter.setParameter("blurbText", (Object)"cheese");
        AssertJUnit.assertEquals((int)1, (int)query.getResultSize());
        List result = query.list();
        Person person = (Person)result.get(0);
        AssertJUnit.assertEquals((String)"MiniGoat", (String)person.getName());
        AssertJUnit.assertEquals((String)"Eats cheese", (String)person.getBlurb());
        query.disableFullTextFilter("personFilter");
        AssertJUnit.assertEquals((int)2, (int)query.getResultSize());
    }

    public void testCombinationOfFilters() throws Exception {
        this.prepareTestData();
        this.person4 = new Person();
        this.person4.setName("ExtraGoat");
        this.person4.setBlurb("Eats grass and is retired");
        this.person4.setAge(70);
        this.cache1.put((Object)"ExtraGoat", (Object)this.person4);
        this.queryParser = TestQueryHelperFactory.createQueryParser("blurb");
        Query luceneQuery = this.queryParser.parse("eats");
        CacheQuery query = Search.getSearchManager(this.cache1).getQuery(luceneQuery, new Class[0]);
        FullTextFilter filter = query.enableFullTextFilter("personFilter");
        filter.setParameter("blurbText", (Object)"grass");
        AssertJUnit.assertEquals((int)2, (int)query.getResultSize());
        FullTextFilter ageFilter = query.enableFullTextFilter("personAgeFilter");
        ageFilter.setParameter("age", (Object)70);
        AssertJUnit.assertEquals((int)1, (int)query.getResultSize());
        List result = query.list();
        Person person = (Person)result.get(0);
        AssertJUnit.assertEquals((String)"ExtraGoat", (String)person.getName());
        AssertJUnit.assertEquals((int)70, (int)person.getAge());
        query.disableFullTextFilter("personFilter");
        query.disableFullTextFilter("personAgeFilter");
        AssertJUnit.assertEquals((int)3, (int)query.getResultSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSearchKeyTransformer() throws Exception {
        Cache cache1 = (Cache)this.caches().get(0);
        Cache cache2 = (Cache)this.caches().get(1);
        SearchManager manager = Search.getSearchManager((Cache)cache1);
        SearchManager manager1 = Search.getSearchManager((Cache)cache2);
        manager.registerKeyTransformer(CustomKey3.class, CustomKey3Transformer.class);
        manager1.registerKeyTransformer(CustomKey3.class, CustomKey3Transformer.class);
        this.prepareTestedObjects();
        TransactionManager transactionManager = cache1.getAdvancedCache().getTransactionManager();
        CustomKey3 customeKey1 = new CustomKey3("Navin");
        CustomKey3 customeKey2 = new CustomKey3("BigGoat");
        CustomKey3 customeKey3 = new CustomKey3("MiniGoat");
        if (this.transactionsEnabled()) {
            transactionManager.begin();
        }
        cache1.put((Object)customeKey1, (Object)this.person1);
        cache1.put((Object)customeKey2, (Object)this.person2);
        cache2.put((Object)customeKey3, (Object)this.person3);
        if (this.transactionsEnabled()) {
            transactionManager.commit();
        }
        this.queryParser = TestQueryHelperFactory.createQueryParser("blurb");
        Query luceneQuery = this.queryParser.parse("Eats");
        CacheQuery cacheQuery = manager.getQuery(luceneQuery, new Class[0]);
        int counter = 0;
        ResultIterator found = cacheQuery.iterator(new FetchOptions().fetchMode(FetchOptions.FetchMode.LAZY));
        try {
            while (found.hasNext()) {
                found.next();
                ++counter;
            }
        }
        finally {
            found.close();
        }
        AssertJUnit.assertEquals((int)2, (int)counter);
    }
}

