/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.embedded;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.infinispan.Cache;
import org.infinispan.query.Search;
import org.infinispan.query.dsl.FilterConditionEndContext;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.query.dsl.SortOrder;
import org.infinispan.query.dsl.embedded.AbstractQueryDslTest;
import org.infinispan.query.dsl.embedded.sample_domain_model.Account;
import org.infinispan.query.dsl.embedded.sample_domain_model.Address;
import org.infinispan.query.dsl.embedded.sample_domain_model.Transaction;
import org.infinispan.query.dsl.embedded.sample_domain_model.User;
import org.junit.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="query.dsl.QueryDslConditionsTest")
public class QueryDslConditionsTest
extends AbstractQueryDslTest {
    @BeforeMethod
    protected void populateCache() throws Exception {
        User user1 = new User();
        user1.setId(1);
        user1.setName("John");
        user1.setSurname("Doe");
        user1.setGender(User.Gender.MALE);
        user1.setAccountIds(new HashSet<Integer>(Arrays.asList(1, 2)));
        Address address1 = new Address();
        address1.setStreet("Main Street");
        address1.setPostCode("X1234");
        user1.setAddresses(Collections.singletonList(address1));
        User user2 = new User();
        user2.setId(2);
        user2.setName("Spider");
        user2.setSurname("Man");
        user2.setGender(User.Gender.MALE);
        user2.setAccountIds(Collections.singleton(3));
        Address address2 = new Address();
        address2.setStreet("Old Street");
        address2.setPostCode("Y12");
        Address address3 = new Address();
        address3.setStreet("Bond Street");
        address3.setPostCode("ZZ");
        user2.setAddresses(Arrays.asList(address2, address3));
        User user3 = new User();
        user3.setId(3);
        user3.setName("Spider");
        user3.setSurname("Woman");
        user3.setGender(User.Gender.FEMALE);
        user3.setAccountIds(Collections.<Integer>emptySet());
        Account account1 = new Account();
        account1.setId(1);
        account1.setDescription("John Doe's first bank account");
        account1.setCreationDate(this.DATE_FORMAT.parse("2013-01-03"));
        Account account2 = new Account();
        account2.setId(2);
        account2.setDescription("John Doe's second bank account");
        account2.setCreationDate(this.DATE_FORMAT.parse("2013-01-04"));
        Account account3 = new Account();
        account3.setId(3);
        account3.setDescription("Spider Man's bank account");
        account3.setCreationDate(this.DATE_FORMAT.parse("2013-01-20"));
        Transaction transaction0 = new Transaction();
        transaction0.setId(0);
        transaction0.setDescription("Birthday present");
        transaction0.setAccountId(1);
        transaction0.setAmount(1800.0);
        transaction0.setDate(this.DATE_FORMAT.parse("2012-09-07"));
        transaction0.setDebit(false);
        Transaction transaction1 = new Transaction();
        transaction1.setId(1);
        transaction1.setDescription("Feb. rent payment");
        transaction1.setAccountId(1);
        transaction1.setAmount(1500.0);
        transaction1.setDate(this.DATE_FORMAT.parse("2013-01-05"));
        transaction1.setDebit(true);
        Transaction transaction2 = new Transaction();
        transaction2.setId(2);
        transaction2.setDescription("Starbucks");
        transaction2.setAccountId(1);
        transaction2.setAmount(23.0);
        transaction2.setDate(this.DATE_FORMAT.parse("2013-01-09"));
        transaction2.setDebit(true);
        Transaction transaction3 = new Transaction();
        transaction3.setId(3);
        transaction3.setDescription("Hotel");
        transaction3.setAccountId(2);
        transaction3.setAmount(45.0);
        transaction3.setDate(this.DATE_FORMAT.parse("2013-02-27"));
        transaction3.setDebit(true);
        Transaction transaction4 = new Transaction();
        transaction4.setId(4);
        transaction4.setDescription("Last january");
        transaction4.setAccountId(2);
        transaction4.setAmount(95.0);
        transaction4.setDate(this.DATE_FORMAT.parse("2013-01-31"));
        transaction4.setDebit(true);
        Transaction transaction5 = new Transaction();
        transaction5.setId(5);
        transaction5.setDescription("Popcorn");
        transaction5.setAccountId(2);
        transaction5.setAmount(5.0);
        transaction5.setDate(this.DATE_FORMAT.parse("2013-01-01"));
        transaction5.setDebit(true);
        this.cache.put((Object)("user_" + user1.getId()), (Object)user1);
        this.cache.put((Object)("user_" + user2.getId()), (Object)user2);
        this.cache.put((Object)("user_" + user3.getId()), (Object)user3);
        this.cache.put((Object)("account_" + account1.getId()), (Object)account1);
        this.cache.put((Object)("account_" + account2.getId()), (Object)account2);
        this.cache.put((Object)("account_" + account3.getId()), (Object)account3);
        this.cache.put((Object)("transaction_" + transaction0.getId()), (Object)transaction0);
        this.cache.put((Object)("transaction_" + transaction1.getId()), (Object)transaction1);
        this.cache.put((Object)("transaction_" + transaction2.getId()), (Object)transaction2);
        this.cache.put((Object)("transaction_" + transaction3.getId()), (Object)transaction3);
        this.cache.put((Object)("transaction_" + transaction4.getId()), (Object)transaction4);
        this.cache.put((Object)("transaction_" + transaction5.getId()), (Object)transaction5);
    }

    public void testIndexPresence() {
        SearchFactoryImplementor searchFactory = (SearchFactoryImplementor)Search.getSearchManager((Cache)this.cache).getSearchFactory();
        Assert.assertNotNull((Object)searchFactory.getIndexManagerHolder().getIndexManager(User.class.getName()));
        Assert.assertNotNull((Object)searchFactory.getIndexManagerHolder().getIndexManager(Account.class.getName()));
        Assert.assertNotNull((Object)searchFactory.getIndexManagerHolder().getIndexManager(Transaction.class.getName()));
        Assert.assertNull((Object)searchFactory.getIndexManagerHolder().getIndexManager(Address.class.getName()));
    }

    public void testEq1() throws Exception {
        QueryFactory qf = Search.getSearchManager((Cache)this.cache).getQueryFactory();
        Query q = qf.from(User.class).having("name").eq((Object)"John").toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"John", (Object)((User)list.get(0)).getName());
        Assert.assertEquals((Object)"Doe", (Object)((User)list.get(0)).getSurname());
    }

    public void testEq() throws Exception {
        QueryFactory qf = Search.getSearchManager((Cache)this.cache).getQueryFactory();
        Query q = qf.from(User.class).having("name").eq((Object)"Jacob").toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)0L, (long)list.size());
    }

    public void testEqInNested1() throws Exception {
        QueryFactory qf = Search.getSearchManager((Cache)this.cache).getQueryFactory();
        Query q = qf.from(User.class).having("addresses.postCode").eq((Object)"X1234").toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"X1234", (Object)((User)list.get(0)).getAddresses().get(0).getPostCode());
    }

    public void testEqInNested2() throws Exception {
        QueryFactory qf = Search.getSearchManager((Cache)this.cache).getQueryFactory();
        Query q = qf.from(User.class).having("addresses.postCode").eq((Object)"Y12").toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)2L, (long)((User)list.get(0)).getAddresses().size());
    }

    public void testLike() throws Exception {
        QueryFactory qf = Search.getSearchManager((Cache)this.cache).getQueryFactory();
        Query q = qf.from(Transaction.class).having("description").like("%rent%").toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((Transaction)list.get(0)).getAccountId());
        Assert.assertEquals((double)1500.0, (double)((Transaction)list.get(0)).getAmount(), (double)0.0);
    }

    public void testBetween1() throws Exception {
        QueryFactory qf = Search.getSearchManager((Cache)this.cache).getQueryFactory();
        Query q = qf.from(Transaction.class).having("date").between((Object)this.DATE_FORMAT.parse("2013-01-01"), (Object)this.DATE_FORMAT.parse("2013-01-31")).toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)4L, (long)list.size());
        for (Transaction t : list) {
            Assert.assertTrue((t.getDate().compareTo(this.DATE_FORMAT.parse("2013-01-31")) <= 0 ? 1 : 0) != 0);
            Assert.assertTrue((t.getDate().compareTo(this.DATE_FORMAT.parse("2013-01-01")) >= 0 ? 1 : 0) != 0);
        }
    }

    public void testBetween2() throws Exception {
        QueryFactory qf = Search.getSearchManager((Cache)this.cache).getQueryFactory();
        Query q = qf.from(Transaction.class).having("date").between((Object)this.DATE_FORMAT.parse("2013-01-01"), (Object)this.DATE_FORMAT.parse("2013-01-31")).includeUpper(false).toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)3L, (long)list.size());
        for (Transaction t : list) {
            Assert.assertTrue((t.getDate().compareTo(this.DATE_FORMAT.parse("2013-01-31")) < 0 ? 1 : 0) != 0);
            Assert.assertTrue((t.getDate().compareTo(this.DATE_FORMAT.parse("2013-01-01")) >= 0 ? 1 : 0) != 0);
        }
    }

    public void testBetween3() throws Exception {
        QueryFactory qf = Search.getSearchManager((Cache)this.cache).getQueryFactory();
        Query q = qf.from(Transaction.class).having("date").between((Object)this.DATE_FORMAT.parse("2013-01-01"), (Object)this.DATE_FORMAT.parse("2013-01-31")).includeLower(false).toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)3L, (long)list.size());
        for (Transaction t : list) {
            Assert.assertTrue((t.getDate().compareTo(this.DATE_FORMAT.parse("2013-01-31")) <= 0 ? 1 : 0) != 0);
            Assert.assertTrue((t.getDate().compareTo(this.DATE_FORMAT.parse("2013-01-01")) > 0 ? 1 : 0) != 0);
        }
    }

    public void testGt() throws Exception {
        QueryFactory qf = Search.getSearchManager((Cache)this.cache).getQueryFactory();
        Query q = qf.from(Transaction.class).having("amount").gt((Object)1500).toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((((Transaction)list.get(0)).getAmount() > 1500.0 ? 1 : 0) != 0);
    }

    public void testGte() throws Exception {
        QueryFactory qf = Search.getSearchManager((Cache)this.cache).getQueryFactory();
        Query q = qf.from(Transaction.class).having("amount").gte((Object)1500).toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        for (Transaction t : list) {
            Assert.assertTrue((t.getAmount() >= 1500.0 ? 1 : 0) != 0);
        }
    }

    public void testLt() throws Exception {
        QueryFactory qf = Search.getSearchManager((Cache)this.cache).getQueryFactory();
        Query q = qf.from(Transaction.class).having("amount").lt((Object)1500).toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)4L, (long)list.size());
        for (Transaction t : list) {
            Assert.assertTrue((t.getAmount() < 1500.0 ? 1 : 0) != 0);
        }
    }

    public void testLte() throws Exception {
        QueryFactory qf = Search.getSearchManager((Cache)this.cache).getQueryFactory();
        Query q = qf.from(Transaction.class).having("amount").lte((Object)1500).toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)5L, (long)list.size());
        for (Transaction t : list) {
            Assert.assertTrue((t.getAmount() <= 1500.0 ? 1 : 0) != 0);
        }
    }

    public void testAnd1() throws Exception {
        QueryFactory qf = Search.getSearchManager((Cache)this.cache).getQueryFactory();
        Query q = qf.from(User.class).having("name").eq((Object)"Spider").and().having("surname").eq((Object)"Man").toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)2L, (long)((User)list.get(0)).getId());
    }

    public void testAnd2() throws Exception {
        QueryFactory qf = Search.getSearchManager((Cache)this.cache).getQueryFactory();
        Query q = qf.from(User.class).having("name").eq((Object)"Spider").and(qf.having("surname").eq((Object)"Man")).toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)2L, (long)((User)list.get(0)).getId());
    }

    public void testAnd3() throws Exception {
        QueryFactory qf = Search.getSearchManager((Cache)this.cache).getQueryFactory();
        Query q = qf.from(User.class).having("gender").eq((Object)User.Gender.MALE).and().having("gender").eq((Object)User.Gender.FEMALE).toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)0L, (long)list.size());
    }

    public void testAnd4() throws Exception {
        QueryFactory qf = Search.getSearchManager((Cache)this.cache).getQueryFactory();
        Query q = qf.from(User.class).having("name").eq((Object)"Spider").or(qf.having("name").eq((Object)"John")).and(qf.having("surname").eq((Object)"Man")).toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
    }

    public void testOr1() throws Exception {
        QueryFactory qf = Search.getSearchManager((Cache)this.cache).getQueryFactory();
        Query q = qf.from(User.class).having("surname").eq((Object)"Man").or().having("surname").eq((Object)"Woman").toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        for (User u : list) {
            Assert.assertEquals((Object)"Spider", (Object)u.getName());
        }
    }

    public void testOr2() throws Exception {
        QueryFactory qf = Search.getSearchManager((Cache)this.cache).getQueryFactory();
        Query q = qf.from(User.class).having("surname").eq((Object)"Man").or(qf.having("surname").eq((Object)"Woman")).toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        for (User u : list) {
            Assert.assertEquals((Object)"Spider", (Object)u.getName());
        }
    }

    public void testOr3() throws Exception {
        QueryFactory qf = Search.getSearchManager((Cache)this.cache).getQueryFactory();
        Query q = qf.from(User.class).having("gender").eq((Object)User.Gender.MALE).or().having("gender").eq((Object)User.Gender.FEMALE).toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)3L, (long)list.size());
    }

    public void testNot1() throws Exception {
        QueryFactory qf = Search.getSearchManager((Cache)this.cache).getQueryFactory();
        Query q = qf.from(User.class).not().having("name").eq((Object)"Spider").toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"John", (Object)((User)list.get(0)).getName());
    }

    public void testNot2() throws Exception {
        QueryFactory qf = Search.getSearchManager((Cache)this.cache).getQueryFactory();
        Query q = qf.from(User.class).not().not().having("surname").eq((Object)"Doe").toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"John", (Object)((User)list.get(0)).getName());
    }

    public void testNot3() throws Exception {
        QueryFactory qf = Search.getSearchManager((Cache)this.cache).getQueryFactory();
        Query q = qf.from(User.class).not().having("name").eq((Object)"John").and().having("surname").eq((Object)"Man").toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"Spider", (Object)((User)list.get(0)).getName());
    }

    public void testNot4() throws Exception {
        QueryFactory qf = Search.getSearchManager((Cache)this.cache).getQueryFactory();
        Query q = qf.from(User.class).having("surname").eq((Object)"Man").and().not().having("name").eq((Object)"John").toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"Spider", (Object)((User)list.get(0)).getName());
    }

    public void testNot5() throws Exception {
        QueryFactory qf = Search.getSearchManager((Cache)this.cache).getQueryFactory();
        Query q = qf.from(User.class).not().having("name").eq((Object)"Spider").or().having("surname").eq((Object)"Man").toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        for (User u : list) {
            Assert.assertFalse((boolean)"Woman".equals(u.getSurname()));
        }
    }

    public void testNot6() throws Exception {
        QueryFactory qf = Search.getSearchManager((Cache)this.cache).getQueryFactory();
        Query q = qf.from(User.class).not(qf.not(qf.having("gender").eq((Object)User.Gender.FEMALE))).toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertTrue((boolean)((User)list.get(0)).getSurname().equals("Woman"));
    }

    public void testNot7() throws Exception {
        QueryFactory qf = Search.getSearchManager((Cache)this.cache).getQueryFactory();
        Query q = qf.from(User.class).having("gender").eq((Object)User.Gender.FEMALE).and().not(qf.having("name").eq((Object)"Spider")).toBuilder().build();
        List list = q.list();
        Assert.assertTrue((boolean)list.isEmpty());
    }

    public void testEmptyQuery() throws Exception {
        QueryFactory qf = Search.getSearchManager((Cache)this.cache).getQueryFactory();
        Query q = qf.from(User.class).build();
        List list = q.list();
        Assert.assertEquals((long)3L, (long)list.size());
    }

    public void testIsNull() throws Exception {
        QueryFactory qf = Search.getSearchManager((Cache)this.cache).getQueryFactory();
        Query q = qf.from(User.class).having("addresses").isNull().toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)3L, (long)((User)list.get(0)).getId());
    }

    public void testContains1() throws Exception {
        QueryFactory qf = Search.getSearchManager((Cache)this.cache).getQueryFactory();
        Query q = qf.from(User.class).having("accountIds").contains((Object)2).toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((User)list.get(0)).getId());
    }

    public void testContains2() throws Exception {
        QueryFactory qf = Search.getSearchManager((Cache)this.cache).getQueryFactory();
        Query q = qf.from(User.class).having("accountIds").contains((Object)42).toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)0L, (long)list.size());
    }

    public void testContainsAll1() throws Exception {
        QueryFactory qf = Search.getSearchManager((Cache)this.cache).getQueryFactory();
        Query q = qf.from(User.class).having("accountIds").containsAll(new Object[]{1, 2}).toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((User)list.get(0)).getId());
    }

    public void testContainsAll2() throws Exception {
        QueryFactory qf = Search.getSearchManager((Cache)this.cache).getQueryFactory();
        Query q = qf.from(User.class).having("accountIds").containsAll(Collections.singleton(1)).toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((User)list.get(0)).getId());
    }

    public void testContainsAll3() throws Exception {
        QueryFactory qf = Search.getSearchManager((Cache)this.cache).getQueryFactory();
        Query q = qf.from(User.class).having("accountIds").containsAll(new Object[]{1, 2, 3}).toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)0L, (long)list.size());
    }

    public void testContainsAll4() throws Exception {
        QueryFactory qf = Search.getSearchManager((Cache)this.cache).getQueryFactory();
        Query q = qf.from(User.class).having("accountIds").containsAll(Collections.emptySet()).toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)3L, (long)list.size());
    }

    public void testContainsAny1() throws Exception {
        QueryFactory qf = Search.getSearchManager((Cache)this.cache).getQueryFactory();
        Query q = qf.from(User.class).orderBy("id", SortOrder.ASC).having("accountIds").containsAny(new Object[]{2, 3}).toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((User)list.get(0)).getId());
        Assert.assertEquals((long)2L, (long)((User)list.get(1)).getId());
    }

    public void testContainsAny2() throws Exception {
        QueryFactory qf = Search.getSearchManager((Cache)this.cache).getQueryFactory();
        Query q = qf.from(User.class).having("accountIds").containsAny(new Object[]{4, 5}).toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)0L, (long)list.size());
    }

    public void testContainsAny3() throws Exception {
        QueryFactory qf = Search.getSearchManager((Cache)this.cache).getQueryFactory();
        Query q = qf.from(User.class).having("accountIds").containsAny(Collections.emptySet()).toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)3L, (long)list.size());
    }

    public void testIn1() throws Exception {
        QueryFactory qf = Search.getSearchManager((Cache)this.cache).getQueryFactory();
        List<Integer> ids = Arrays.asList(1, 3);
        Query q = qf.from(User.class).having("id").in(ids).toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        for (User u : list) {
            Assert.assertTrue((boolean)ids.contains(u.getId()));
        }
    }

    public void testIn2() throws Exception {
        QueryFactory qf = Search.getSearchManager((Cache)this.cache).getQueryFactory();
        Query q = qf.from(User.class).having("id").in(new Object[]{4}).toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)0L, (long)list.size());
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testIn3() throws Exception {
        QueryFactory qf = Search.getSearchManager((Cache)this.cache).getQueryFactory();
        qf.from(User.class).having("id").in(Collections.emptySet());
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testIn4() throws Exception {
        QueryFactory qf = Search.getSearchManager((Cache)this.cache).getQueryFactory();
        Collection collection = null;
        qf.from(User.class).having("id").in(collection);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testIn5() throws Exception {
        QueryFactory qf = Search.getSearchManager((Cache)this.cache).getQueryFactory();
        Object[] array = null;
        qf.from(User.class).having("id").in(array);
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testIn6() throws Exception {
        QueryFactory qf = Search.getSearchManager((Cache)this.cache).getQueryFactory();
        Object[] array = new Object[]{};
        qf.from(User.class).having("id").in(array);
    }

    public void testSampleDomainQuery1() throws Exception {
        QueryFactory qf = Search.getSearchManager((Cache)this.cache).getQueryFactory();
        Query q = qf.from(User.class).having("gender").eq((Object)User.Gender.MALE).toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((Object)"John", (Object)((User)list.get(0)).getName());
        Assert.assertEquals((Object)"Spider", (Object)((User)list.get(1)).getName());
    }

    public void testSampleDomainQuery2() throws Exception {
        QueryFactory qf = Search.getSearchManager((Cache)this.cache).getQueryFactory();
        Query q = qf.from(User.class).not(qf.having("gender").eq((Object)User.Gender.FEMALE)).and(qf.not().not(qf.having("gender").eq((Object)User.Gender.MALE))).toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((Object)"John", (Object)((User)list.get(0)).getName());
        Assert.assertEquals((Object)"Spider", (Object)((User)list.get(1)).getName());
    }

    @Test(enabled=false, description="String literal escaping is not properly done yet")
    public void testStringEscape() throws Exception {
        QueryFactory qf = Search.getSearchManager((Cache)this.cache).getQueryFactory();
        Query q = qf.from(Account.class).having("description").eq((Object)"John Doe's first bank account").toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)2L, (long)((Account)list.get(0)).getId());
    }

    public void testSampleDomainQuery3() throws Exception {
        QueryFactory qf = Search.getSearchManager((Cache)this.cache).getQueryFactory();
        Query q = qf.from(User.class).having("gender").eq((Object)User.Gender.MALE).toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((Object)"John", (Object)((User)list.get(0)).getName());
        Assert.assertEquals((Object)"Spider", (Object)((User)list.get(1)).getName());
    }

    public void testSampleDomainQuery4() throws Exception {
        QueryFactory qf = Search.getSearchManager((Cache)this.cache).getQueryFactory();
        Query q = qf.from(User.class).orderBy("name", SortOrder.DESC).build();
        List list = q.list();
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertEquals((Object)"Spider", (Object)((User)list.get(0)).getName());
        Assert.assertEquals((Object)"Spider", (Object)((User)list.get(1)).getName());
        Assert.assertEquals((Object)"John", (Object)((User)list.get(2)).getName());
    }

    public void testSampleDomainQuery5() throws Exception {
        QueryFactory qf = Search.getSearchManager((Cache)this.cache).getQueryFactory();
        Query q = qf.from(User.class).orderBy("name", SortOrder.DESC).setProjection(new String[]{"name"}).build();
        List list = q.list();
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((Object[])list.get(0)).length);
        Assert.assertEquals((long)1L, (long)((Object[])list.get(1)).length);
        Assert.assertEquals((long)1L, (long)((Object[])list.get(2)).length);
        Assert.assertEquals((Object)"Spider", (Object)((Object[])list.get(0))[0]);
        Assert.assertEquals((Object)"Spider", (Object)((Object[])list.get(1))[0]);
        Assert.assertEquals((Object)"John", (Object)((Object[])list.get(2))[0]);
    }

    public void testProjectionOnOptionalField() throws Exception {
        QueryFactory qf = Search.getSearchManager((Cache)this.cache).getQueryFactory();
        Query q = qf.from(User.class).setProjection(new String[]{"id", "addresses.postCode"}).orderBy("id", SortOrder.ASC).build();
        List list = q.list();
        Assert.assertEquals((long)3L, (long)list.size());
        Assert.assertEquals((Object)1, (Object)((Object[])list.get(0))[0]);
        Assert.assertEquals((Object)"X1234", (Object)((Object[])list.get(0))[1]);
        Assert.assertEquals((Object)2, (Object)((Object[])list.get(1))[0]);
        Assert.assertEquals((Object)"Y12", (Object)((Object[])list.get(1))[1]);
        Assert.assertEquals((Object)3, (Object)((Object[])list.get(2))[0]);
        Assert.assertNull((Object)((Object[])list.get(2))[1]);
    }

    public void testSampleDomainQuery6() throws Exception {
        QueryFactory qf = Search.getSearchManager((Cache)this.cache).getQueryFactory();
        Query q = qf.from(User.class).having("name").eq((Object)"John").and().having("surname").eq((Object)"Doe").toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"John", (Object)((User)list.get(0)).getName());
        Assert.assertEquals((Object)"Doe", (Object)((User)list.get(0)).getSurname());
    }

    public void testSampleDomainQuery7() throws Exception {
        QueryFactory qf = Search.getSearchManager((Cache)this.cache).getQueryFactory();
        Query q = qf.from(Transaction.class).having("accountId").eq((Object)1).and().having("description").like("%rent%").toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((Transaction)list.get(0)).getId());
        Assert.assertEquals((long)1L, (long)((Transaction)list.get(0)).getAccountId());
        Assert.assertTrue((boolean)((Transaction)list.get(0)).getDescription().contains("rent"));
    }

    public void testSampleDomainQuery8() throws Exception {
        QueryFactory qf = Search.getSearchManager((Cache)this.cache).getQueryFactory();
        Query q = qf.from(Transaction.class).having("date").between((Object)this.DATE_FORMAT.parse("2013-01-01"), (Object)this.DATE_FORMAT.parse("2013-01-31")).toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)4L, (long)list.size());
        Assert.assertTrue((((Transaction)list.get(0)).getDate().compareTo(this.DATE_FORMAT.parse("2013-01-31")) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((((Transaction)list.get(0)).getDate().compareTo(this.DATE_FORMAT.parse("2013-01-01")) > 0 ? 1 : 0) != 0);
        Assert.assertTrue((((Transaction)list.get(1)).getDate().compareTo(this.DATE_FORMAT.parse("2013-01-31")) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((((Transaction)list.get(1)).getDate().compareTo(this.DATE_FORMAT.parse("2013-01-01")) > 0 ? 1 : 0) != 0);
    }

    public void testSampleDomainQuery9() throws Exception {
        QueryFactory qf = Search.getSearchManager((Cache)this.cache).getQueryFactory();
        Query q = qf.from(Transaction.class).setProjection(new String[]{"date"}).having("date").between((Object)this.DATE_FORMAT.parse("2013-01-01"), (Object)this.DATE_FORMAT.parse("2013-01-31")).toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)4L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((Object[])list.get(0)).length);
        Assert.assertEquals((long)1L, (long)((Object[])list.get(1)).length);
        Assert.assertEquals((long)1L, (long)((Object[])list.get(2)).length);
        Assert.assertEquals((long)1L, (long)((Object[])list.get(3)).length);
        for (int i = 0; i < 4; ++i) {
            Date d = (Date)((Object[])list.get(i))[0];
            Assert.assertTrue((d.compareTo(this.DATE_FORMAT.parse("2013-01-31")) <= 0 ? 1 : 0) != 0);
            Assert.assertTrue((d.compareTo(this.DATE_FORMAT.parse("2013-01-01")) >= 0 ? 1 : 0) != 0);
        }
    }

    public void testSampleDomainQuery10() throws Exception {
        QueryFactory qf = Search.getSearchManager((Cache)this.cache).getQueryFactory();
        Query q = qf.from(Transaction.class).having("accountId").eq((Object)2).and().having("amount").gt((Object)40).toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((((Transaction)list.get(0)).getAmount() > 40.0 ? 1 : 0) != 0);
        Assert.assertTrue((((Transaction)list.get(1)).getAmount() > 40.0 ? 1 : 0) != 0);
    }

    public void testSampleDomainQuery11() throws Exception {
        QueryFactory qf = Search.getSearchManager((Cache)this.cache).getQueryFactory();
        Query q = qf.from(User.class).having("name").eq((Object)"John").and().having("addresses.postCode").eq((Object)"X1234").and(qf.having("accountIds").eq((Object)1)).toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((Object)"Doe", (Object)((User)list.get(0)).getSurname());
    }

    public void testSampleDomainQuery12() throws Exception {
        QueryFactory qf = Search.getSearchManager((Cache)this.cache).getQueryFactory();
        Query q = qf.from(Transaction.class).having("accountId").eq((Object)1).and().not().having("isDebit").eq((Object)true).toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertFalse((boolean)((Transaction)list.get(0)).isDebit());
    }

    public void testSampleDomainQuery13() throws Exception {
        QueryFactory qf = Search.getSearchManager((Cache)this.cache).getQueryFactory();
        Query q = qf.from(User.class).having("accountIds").contains((Object)3).toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)2L, (long)((User)list.get(0)).getId());
        Assert.assertTrue((boolean)((User)list.get(0)).getAccountIds().contains(3));
    }

    public void testSampleDomainQuery14() throws Exception {
        QueryFactory qf = Search.getSearchManager((Cache)this.cache).getQueryFactory();
        Query q = qf.from(User.class).having("accountIds").containsAll(new Object[]{2, 1}).toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)1L, (long)((User)list.get(0)).getId());
        Assert.assertTrue((boolean)((User)list.get(0)).getAccountIds().contains(1));
        Assert.assertTrue((boolean)((User)list.get(0)).getAccountIds().contains(2));
    }

    public void testSampleDomainQuery15() throws Exception {
        QueryFactory qf = Search.getSearchManager((Cache)this.cache).getQueryFactory();
        Query q = qf.from(User.class).having("accountIds").containsAny(new Object[]{1, 3}).toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)Arrays.asList(1, 2).contains(((User)list.get(0)).getId()));
        Assert.assertTrue((boolean)Arrays.asList(1, 2).contains(((User)list.get(1)).getId()));
    }

    public void testSampleDomainQuery16() throws Exception {
        for (int i = 0; i < 50; ++i) {
            Transaction transaction = new Transaction();
            transaction.setId(50 + i);
            transaction.setDescription("Expensive shoes " + i);
            transaction.setAccountId(2);
            transaction.setAmount(100 + i);
            transaction.setDate(this.DATE_FORMAT.parse("2013-08-20"));
            transaction.setDebit(true);
            this.cache.put((Object)("transaction_" + transaction.getId()), (Object)transaction);
        }
        QueryFactory qf = Search.getSearchManager((Cache)this.cache).getQueryFactory();
        Query q = qf.from(Transaction.class).startOffset(20L).maxResults(10).orderBy("id", SortOrder.ASC).having("accountId").eq((Object)2).and().having("description").like("Expensive%").toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)10L, (long)list.size());
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((Object)("Expensive shoes " + (20 + i)), (Object)((Transaction)list.get(i)).getDescription());
        }
    }

    public void testSampleDomainQuery17() throws Exception {
        QueryFactory qf = Search.getSearchManager((Cache)this.cache).getQueryFactory();
        Query q1 = qf.from(User.class).having("id").eq((Object)1).toBuilder().build();
        List users = q1.list();
        Query q2 = qf.from(Account.class).orderBy("description", SortOrder.ASC).having("id").in(((User)users.get(0)).getAccountIds()).toBuilder().build();
        List list = q2.list();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((Object)"John Doe's first bank account", (Object)((Account)list.get(0)).getDescription());
        Assert.assertEquals((Object)"John Doe's second bank account", (Object)((Account)list.get(1)).getDescription());
    }

    public void testSampleDomainQuery18() throws Exception {
        QueryFactory qf = Search.getSearchManager((Cache)this.cache).getQueryFactory();
        Query q = qf.from(Transaction.class).having("accountId").eq((Object)1).and(qf.having("amount").gt((Object)1600).or().having("description").like("%rent%")).toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertEquals((Object)"Birthday present", (Object)((Transaction)list.get(0)).getDescription());
        Assert.assertEquals((Object)"Feb. rent payment", (Object)((Transaction)list.get(1)).getDescription());
    }

    public void testSampleDomainQuery19() throws Exception {
        QueryFactory qf = Search.getSearchManager((Cache)this.cache).getQueryFactory();
        Query q = qf.from(User.class).having("addresses.postCode").in(new Object[]{"ZZ", "X1234"}).toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)Arrays.asList(1, 2).contains(((User)list.get(0)).getId()));
        Assert.assertTrue((boolean)Arrays.asList(1, 2).contains(((User)list.get(1)).getId()));
    }

    public void testSampleDomainQuery20() throws Exception {
        QueryFactory qf = Search.getSearchManager((Cache)this.cache).getQueryFactory();
        Query q = qf.from(User.class).not().having("addresses.postCode").in(new Object[]{"X1234"}).toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)Arrays.asList(2, 3).contains(((User)list.get(0)).getId()));
        Assert.assertTrue((boolean)Arrays.asList(2, 3).contains(((User)list.get(1)).getId()));
    }

    public void testSampleDomainQuery21() throws Exception {
        QueryFactory qf = Search.getSearchManager((Cache)this.cache).getQueryFactory();
        Query q = qf.from(User.class).not().having("addresses").isNull().toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)Arrays.asList(1, 2).contains(((User)list.get(0)).getId()));
        Assert.assertTrue((boolean)Arrays.asList(1, 2).contains(((User)list.get(1)).getId()));
    }

    public void testSampleDomainQuery22() throws Exception {
        QueryFactory qf = Search.getSearchManager((Cache)this.cache).getQueryFactory();
        Query q = qf.from(User.class).not().having("addresses.postCode").like("%123%").toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)Arrays.asList(2, 3).contains(((User)list.get(0)).getId()));
        Assert.assertTrue((boolean)Arrays.asList(2, 3).contains(((User)list.get(1)).getId()));
    }

    public void testSampleDomainQuery23() throws Exception {
        QueryFactory qf = Search.getSearchManager((Cache)this.cache).getQueryFactory();
        Query q = qf.from(User.class).not().having("id").between((Object)1, (Object)2).toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals((long)3L, (long)((User)list.get(0)).getId());
    }

    public void testSampleDomainQuery24() throws Exception {
        QueryFactory qf = Search.getSearchManager((Cache)this.cache).getQueryFactory();
        Query q = qf.from(User.class).not().having("id").between((Object)1, (Object)2).includeLower(false).toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)Arrays.asList(1, 3).contains(((User)list.get(0)).getId()));
        Assert.assertTrue((boolean)Arrays.asList(1, 3).contains(((User)list.get(1)).getId()));
    }

    public void testSampleDomainQuery25() throws Exception {
        QueryFactory qf = Search.getSearchManager((Cache)this.cache).getQueryFactory();
        Query q = qf.from(User.class).not().having("id").between((Object)1, (Object)2).includeUpper(false).toBuilder().build();
        List list = q.list();
        Assert.assertEquals((long)2L, (long)list.size());
        Assert.assertTrue((boolean)Arrays.asList(2, 3).contains(((User)list.get(0)).getId()));
        Assert.assertTrue((boolean)Arrays.asList(2, 3).contains(((User)list.get(1)).getId()));
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void testWrongQueryBuilding1() throws Exception {
        QueryFactory qf = Search.getSearchManager((Cache)this.cache).getQueryFactory();
        Query q = qf.not().having("name").eq((Object)"John").toBuilder().build();
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void testWrongQueryBuilding2() throws Exception {
        QueryFactory qf = Search.getSearchManager((Cache)this.cache).getQueryFactory();
        Query q = qf.from(User.class).having("name").eq((Object)"John").toBuilder().having("surname").eq((Object)"Man").toBuilder().build();
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void testWrongQueryBuilding3() throws Exception {
        QueryFactory qf = Search.getSearchManager((Cache)this.cache).getQueryFactory();
        Query q = qf.from(User.class).not().having("name").eq((Object)"John").toBuilder().not().having("surname").eq((Object)"Man").toBuilder().build();
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void testWrongQueryBuilding4() throws Exception {
        QueryFactory qf = Search.getSearchManager((Cache)this.cache).getQueryFactory();
        Query q = qf.from(User.class).not(qf.having("name").eq((Object)"John")).toBuilder().not(qf.having("surname").eq((Object)"Man")).toBuilder().build();
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void testWrongQueryBuilding5() throws Exception {
        QueryFactory qf = Search.getSearchManager((Cache)this.cache).getQueryFactory();
        Query q = qf.from(User.class).not(qf.having("name").eq((Object)"John")).toBuilder().not(qf.having("surname").eq((Object)"Man")).toBuilder().build();
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testWrongQueryBuilding6() throws Exception {
        QueryFactory qf = Search.getSearchManager((Cache)this.cache).getQueryFactory();
        Query q = qf.from(User.class).having("gender").eq(null).toBuilder().build();
    }

    @Test(expectedExceptions={IllegalStateException.class})
    public void testWrongQueryBuilding7() throws Exception {
        QueryFactory qf = Search.getSearchManager((Cache)this.cache).getQueryFactory();
        FilterConditionEndContext q1 = qf.from(User.class).having("gender");
        q1.eq((Object)User.Gender.MALE);
        q1.eq((Object)User.Gender.FEMALE);
    }
}

