/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.embedded.sample_domain_model;

import java.util.Date;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.NumericField;
import org.hibernate.search.annotations.Store;

@Indexed
public class Transaction {
    @Field(store=Store.YES, analyze=Analyze.NO)
    private int id;
    @Field(store=Store.YES, analyze=Analyze.NO)
    private String description;
    @Field(store=Store.YES, analyze=Analyze.NO)
    private int accountId;
    @Field(store=Store.YES, analyze=Analyze.NO)
    private Date date;
    @Field(store=Store.YES, analyze=Analyze.NO)
    @NumericField
    private double amount;
    @Field(store=Store.YES, analyze=Analyze.NO)
    private boolean isDebit;

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getAccountId() {
        return this.accountId;
    }

    public void setAccountId(int accountId) {
        this.accountId = accountId;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public double getAmount() {
        return this.amount;
    }

    public void setAmount(double amount) {
        this.amount = amount;
    }

    public boolean isDebit() {
        return this.isDebit;
    }

    public void setDebit(boolean isDebit) {
        this.isDebit = isDebit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Transaction that = (Transaction)o;
        if (this.accountId != that.accountId) {
            return false;
        }
        if (Double.compare(that.amount, this.amount) != 0) {
            return false;
        }
        if (this.id != that.id) {
            return false;
        }
        if (this.isDebit != that.isDebit) {
            return false;
        }
        if (this.date != null ? !this.date.equals(that.date) : that.date != null) {
            return false;
        }
        return !(this.description != null ? !this.description.equals(that.description) : that.description != null);
    }

    public int hashCode() {
        int result = this.id;
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + this.accountId;
        result = 31 * result + (this.date != null ? this.date.hashCode() : 0);
        long temp = Double.doubleToLongBits(this.amount);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.isDebit ? 1 : 0);
        return result;
    }

    public String toString() {
        return "Transaction{id=" + this.id + ", description='" + this.description + '\'' + ", accountId=" + this.accountId + ", date=" + this.date + ", amount=" + this.amount + ", isDebit=" + this.isDebit + '}';
    }
}

