/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.embedded.sample_domain_model;

import java.util.List;
import java.util.Set;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.FieldBridge;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.annotations.NumericField;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.bridge.builtin.impl.BuiltinIterableBridge;
import org.infinispan.query.dsl.embedded.sample_domain_model.Address;

@Indexed
public class User {
    @Field(store=Store.YES, analyze=Analyze.NO)
    private int id;
    @Field(store=Store.YES, analyze=Analyze.NO)
    @FieldBridge(impl=BuiltinIterableBridge.class)
    private Set<Integer> accountIds;
    @Field(store=Store.YES, analyze=Analyze.NO)
    private String name;
    @Field(store=Store.YES, analyze=Analyze.NO, indexNullAs="__DEFAULT_NULL_TOKEN__")
    private String surname;
    @Field(store=Store.YES, analyze=Analyze.NO)
    @NumericField
    private int age;
    @Field(store=Store.YES, analyze=Analyze.NO)
    private Gender gender;
    @IndexedEmbedded(indexNullAs="__DEFAULT_NULL_TOKEN__")
    private List<Address> addresses;

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public Set<Integer> getAccountIds() {
        return this.accountIds;
    }

    public void setAccountIds(Set<Integer> accountIds) {
        this.accountIds = accountIds;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSurname() {
        return this.surname;
    }

    public void setSurname(String surname) {
        this.surname = surname;
    }

    public int getAge() {
        return this.age;
    }

    public void setAge(int age) {
        this.age = age;
    }

    public Gender getGender() {
        return this.gender;
    }

    public void setGender(Gender gender) {
        this.gender = gender;
    }

    public List<Address> getAddresses() {
        return this.addresses;
    }

    public void setAddresses(List<Address> addresses) {
        this.addresses = addresses;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        User user = (User)o;
        if (this.age != user.age) {
            return false;
        }
        if (this.id != user.id) {
            return false;
        }
        if (this.accountIds != null ? !this.accountIds.equals(user.accountIds) : user.accountIds != null) {
            return false;
        }
        if (this.addresses != null ? !this.addresses.equals(user.addresses) : user.addresses != null) {
            return false;
        }
        if (this.gender != user.gender) {
            return false;
        }
        if (this.name != null ? !this.name.equals(user.name) : user.name != null) {
            return false;
        }
        return !(this.surname != null ? !this.surname.equals(user.surname) : user.surname != null);
    }

    public int hashCode() {
        int result = this.id;
        result = 31 * result + (this.accountIds != null ? this.accountIds.hashCode() : 0);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.surname != null ? this.surname.hashCode() : 0);
        result = 31 * result + this.age;
        result = 31 * result + (this.gender != null ? this.gender.hashCode() : 0);
        result = 31 * result + (this.addresses != null ? this.addresses.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "User{id=" + this.id + ", name='" + this.name + '\'' + ", surname='" + this.surname + '\'' + ", accountIds=" + this.accountIds + ", addresses=" + this.addresses + ", age=" + this.age + ", gender=" + (Object)((Object)this.gender) + '}';
    }

    public static enum Gender {
        MALE,
        FEMALE;

    }
}

